/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.part;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.PartReportFiller;
import net.sf.jasperreports.engine.part.DelayedPrintPart;
import net.sf.jasperreports.engine.part.FillPart;
import net.sf.jasperreports.engine.part.FillPartPrintOutput;
import net.sf.jasperreports.engine.part.FillPrintPart;
import net.sf.jasperreports.engine.part.FilledPrintPart;
import net.sf.jasperreports.engine.part.PartPrintOutput;

public class FillPrintPartQueue {
    public static final String EXCEPTION_MESSAGE_KEY_CANNOT_REMOVE_HEAD_PART = "engine.part.queue.cannot.remove.head.part";
    public static final String EXCEPTION_MESSAGE_KEY_CANNOT_REPLACE_HEAD_PART = "engine.part.queue.cannot.replace.head.part";
    private FillPrintPart head;
    private FillPrintPart tail;

    public FillPrintPartQueue(PartPrintOutput output) {
        this.head = this.tail = new FilledPrintPart(output);
    }

    public FillPrintPart head() {
        return this.head;
    }

    public FillPrintPart tail() {
        return this.tail;
    }

    public boolean isCollapsed() {
        return this.head == this.tail;
    }

    public FilledPrintPart appendOutput(PartPrintOutput output) {
        FilledPrintPart filledPart = new FilledPrintPart(output);
        this.append(filledPart);
        return filledPart;
    }

    public DelayedPrintPart appendDelayed(FillPart fillPart) {
        DelayedPrintPart delayedPart = new DelayedPrintPart(fillPart);
        this.append(delayedPart);
        return delayedPart;
    }

    protected void append(FillPrintPart part) {
        part.setPreviousPart(this.tail);
        this.tail.setNextPart(part);
        this.tail = part;
    }

    public void fillDelayed(DelayedPrintPart part, PartReportFiller filler, byte evaluation) throws JRException {
        PartPrintOutput appendOutput = part.previousPart().getOutput();
        if (appendOutput != null) {
            part.getFillPart().fill(evaluation, appendOutput);
            this.remove(part);
            this.collapse(part.previousPart());
        } else {
            FillPartPrintOutput localOutput = new FillPartPrintOutput(filler);
            part.getFillPart().fill(evaluation, localOutput);
            FilledPrintPart filledPart = new FilledPrintPart(localOutput);
            this.replace(part, filledPart);
            this.collapse(filledPart);
        }
    }

    protected void remove(DelayedPrintPart part) {
        if (part == this.head) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CANNOT_REMOVE_HEAD_PART, (Object[])null);
        }
        part.previousPart().setNextPart(part.nextPart());
        if (part == this.tail) {
            this.tail = part.previousPart();
        } else {
            part.nextPart().setPreviousPart(part.previousPart());
        }
    }

    protected void replace(FillPrintPart originalPart, FillPrintPart newPart) {
        if (originalPart == this.head) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CANNOT_REPLACE_HEAD_PART, (Object[])null);
        }
        newPart.setPreviousPart(originalPart.previousPart());
        newPart.setNextPart(originalPart.nextPart());
        originalPart.previousPart().setNextPart(newPart);
        if (originalPart == this.tail) {
            this.tail = newPart;
        } else {
            originalPart.nextPart().setPreviousPart(newPart);
        }
    }

    protected void collapse(FillPrintPart part) {
        FillPrintPart next;
        PartPrintOutput output = part.getOutput();
        for (next = part.nextPart(); next != null && next.getOutput() != null; next = next.nextPart()) {
            FillPartPrintOutput nextOutput = (FillPartPrintOutput)next.getOutput();
            output.append(nextOutput);
            nextOutput.getDelayedActions().dispose();
        }
        part.setNextPart(next);
        if (next == null) {
            this.tail = part;
        } else {
            next.setPreviousPart(part);
        }
    }
}

