/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.compilers.ReportExpressionsCompilation;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JasperDesign;

public class ReportSourceCompilation<P extends JRParameter> {
    public static final String PROPERTY_LEGACY_SOURCE_INCLUDED_PARAMETERS = "net.sf.jasperreports.legacy.compiler.source.included.parameters";
    public static final String PROPERTY_LEGACY_SOURCE_INCLUDED_FIELDS = "net.sf.jasperreports.legacy.compiler.source.included.fields";
    public static final String PROPERTY_LEGACY_SOURCE_INCLUDED_VARIABLES = "net.sf.jasperreports.legacy.compiler.source.included.variables";
    public static final String SOURCE_INCLUDED_ALL = "*";
    public static final String SOURCE_INCLUDED_SEPARATOR = ",";
    private final List<JRExpression> expressions;
    private final Map<String, P> parameters;
    private final Map<String, JRField> fields;
    private final Map<String, JRVariable> variables;
    private final JRVariable[] variablesArray;

    public ReportSourceCompilation(JasperReportsContext jasperReportsContext, JasperDesign report, ReportExpressionsCompilation expressionsCompilation, Map<String, P> parameters, Map<String, JRField> fields, Map<String, JRVariable> variables, JRVariable[] variablesArray) {
        this.expressions = expressionsCompilation.getSourceExpressions();
        JRPropertiesUtil properties = JRPropertiesUtil.getInstance(jasperReportsContext);
        String includedParamsProp = properties.getProperty(report, PROPERTY_LEGACY_SOURCE_INCLUDED_PARAMETERS);
        if (includedParamsProp != null && includedParamsProp.trim().equals(SOURCE_INCLUDED_ALL)) {
            this.parameters = parameters;
        } else {
            Set<String> includedParams = ReportSourceCompilation.collectIncluded(parameters, includedParamsProp, (byte)2, this.expressions);
            this.parameters = ReportSourceCompilation.filter(parameters, includedParams);
        }
        String includedFieldsProp = properties.getProperty(report, PROPERTY_LEGACY_SOURCE_INCLUDED_FIELDS);
        if (includedFieldsProp != null && includedFieldsProp.trim().equals(SOURCE_INCLUDED_ALL)) {
            this.fields = fields;
        } else {
            Set<String> includedFields = ReportSourceCompilation.collectIncluded(fields, includedFieldsProp, (byte)3, this.expressions);
            this.fields = ReportSourceCompilation.filter(fields, includedFields);
        }
        String includedVarsProp = properties.getProperty(report, PROPERTY_LEGACY_SOURCE_INCLUDED_VARIABLES);
        if (includedVarsProp != null && includedVarsProp.trim().equals(SOURCE_INCLUDED_ALL)) {
            this.variables = variables;
            this.variablesArray = variablesArray;
        } else {
            Set<String> includedVariables = ReportSourceCompilation.collectIncluded(variables, includedVarsProp, (byte)4, this.expressions);
            this.variables = ReportSourceCompilation.filter(variables, includedVariables);
            this.variablesArray = ReportSourceCompilation.filterVariables(variablesArray, includedVariables);
        }
    }

    public boolean hasSource() {
        return !this.expressions.isEmpty() || this.parameters != null && !this.parameters.isEmpty() || this.fields != null && !this.fields.isEmpty() || this.variables != null && !this.variables.isEmpty();
    }

    public List<JRExpression> getExpressions() {
        return this.expressions;
    }

    public Map<String, P> getParameters() {
        return this.parameters;
    }

    public Map<String, JRField> getFields() {
        return this.fields;
    }

    public Map<String, JRVariable> getVariables() {
        return this.variables;
    }

    public JRVariable[] getVariablesArray() {
        return this.variablesArray;
    }

    protected static Set<String> collectIncluded(Map<String, ?> originalMap, String includeList, byte expressionChunkType, List<JRExpression> expressions) {
        HashSet<String> collected = new HashSet<String>();
        if (includeList != null) {
            ReportSourceCompilation.collectList(originalMap, includeList, collected);
        }
        ReportSourceCompilation.collectExpressionsIncluded(collected, expressionChunkType, expressions);
        return collected;
    }

    protected static void collectExpressionsIncluded(Set<String> collected, byte expressionChunkType, List<JRExpression> expressions) {
        for (JRExpression expression : expressions) {
            JRExpressionChunk[] chunks = expression.getChunks();
            if (chunks == null) continue;
            for (JRExpressionChunk chunk : chunks) {
                if (chunk.getType() != expressionChunkType) continue;
                collected.add(chunk.getText());
            }
        }
    }

    protected static void collectList(Map<String, ?> originalMap, String includeList, Set<String> collected) {
        String[] split;
        for (String token : split = includeList.split(SOURCE_INCLUDED_SEPARATOR)) {
            String name = token.trim();
            if (name.isEmpty() || !originalMap.containsKey(name)) continue;
            collected.add(name);
        }
    }

    protected static <T> Map<String, T> filter(Map<String, T> original, Set<String> included) {
        if (original == null || original.isEmpty()) {
            return original;
        }
        LinkedHashMap<String, T> filtered = new LinkedHashMap<String, T>();
        for (Map.Entry<String, T> entry : original.entrySet()) {
            if (!included.contains(entry.getKey())) continue;
            filtered.put(entry.getKey(), entry.getValue());
        }
        return filtered.size() == original.size() ? original : filtered;
    }

    protected static JRVariable[] filterVariables(JRVariable[] original, Set<String> included) {
        if (original == null || original.length == 0) {
            return original;
        }
        ArrayList<JRVariable> sourceVars = new ArrayList<JRVariable>();
        for (JRVariable variable : original) {
            if (!included.contains(variable.getName())) continue;
            sourceVars.add(variable);
        }
        return sourceVars.size() == original.length ? original : sourceVars.toArray(new JRVariable[sourceVars.size()]);
    }
}

