/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.convert.TextElementConverter;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import net.sf.jasperreports.engine.util.JRTextMeasurerUtil;

public final class TextFieldConverter
extends TextElementConverter {
    private static final TextFieldConverter INSTANCE = new TextFieldConverter();

    private TextFieldConverter() {
    }

    public static TextFieldConverter getInstance() {
        return INSTANCE;
    }

    @Override
    public JRPrintElement convert(ReportConverter reportConverter, JRElement element) {
        JRBasePrintText printText = new JRBasePrintText(reportConverter.getDefaultStyleProvider());
        JRTextField textField = (JRTextField)element;
        this.copyTextElement(reportConverter, textField, printText);
        printText.setMarkup("none");
        printText.setAnchorName(JRExpressionUtil.getExpressionText(textField.getAnchorNameExpression()));
        printText.setBookmarkLevel(textField.getBookmarkLevel());
        printText.setLinkType(textField.getLinkType());
        printText.setPattern(textField.getOwnPattern());
        printText.setText(JRExpressionUtil.getExpressionText(textField.getExpression()));
        JRTextMeasurerUtil.getInstance(reportConverter.getJasperReportsContext()).measureTextElement(printText);
        return printText;
    }
}

