/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.io.IOException;
import java.io.Writer;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.VersionComparator;
import net.sf.jasperreports.engine.xml.ReportWriter;
import net.sf.jasperreports.jackson.util.JacksonUtil;

public class JacksonReportWriter
implements ReportWriter {
    private final JasperReportsContext jasperReportsContext;

    public JacksonReportWriter(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    @Override
    public boolean writeReport(JRReport report, String encoding, Writer out) throws IOException {
        String version = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty(report, "net.sf.jasperreports.report.version");
        if (version == null || new VersionComparator().compare(version, "7.0.0") >= 0) {
            JacksonUtil.getInstance(this.jasperReportsContext).writeXml(report, out);
            return true;
        }
        return false;
    }

    @Override
    public boolean writeTemplate(JRTemplate template, String encoding, Writer out) throws IOException {
        String version = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty("net.sf.jasperreports.report.version");
        if (version == null || new VersionComparator().compare(version, "7.0.0") >= 0) {
            JacksonUtil.getInstance(this.jasperReportsContext).writeXml(template, out);
            return true;
        }
        return false;
    }
}

