/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.struts2;

/**
 * ModelDriven Actions provide a model object to be pushed onto the ValueStack
 * in addition to the Action itself, allowing a FormBean type approach like Struts.
 *
 * @author Jason Carreira
 */
public interface ModelDriven<T> {

    /**
     * Gets the model to be pushed onto the ValueStack instead of the Action itself.
     * <p>
     * Please be aware that all setters and getters of every depth on the object returned by this method are available
     * for user parameter injection!
     *
     * @return the model
     */
    T getModel();

}
