/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.datasource.jaxb;

import javax.activation.DataHandler;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.datasource.jaxb.AttachmentContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MessageContextAttachmentContext
implements AttachmentContext {
    private static final Log log = LogFactory.getLog(MessageContextAttachmentContext.class);
    private final MessageContext msgContext;

    public MessageContextAttachmentContext(MessageContext msgContext) {
        this.msgContext = msgContext;
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public boolean isMTOMEnabled() {
        if (this.msgContext == null) {
            return false;
        }
        String value = (String)this.msgContext.getProperty("enableMTOM");
        return "true".equalsIgnoreCase(value);
    }

    public void setDoingSWA() {
        if (this.msgContext != null) {
            this.msgContext.setDoingSwA(true);
            this.msgContext.setProperty("enableSwA", (Object)"true");
        }
    }

    public void addDataHandler(DataHandler dh, String cid) {
        if (this.msgContext != null) {
            this.msgContext.addAttachment(cid, dh);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"The msgContext is null.  The attachment is not stored");
            log.debug((Object)("   content id=" + cid));
            log.debug((Object)("   dataHandler  =" + dh));
        }
    }

    public DataHandler getDataHandlerForSwA(String blobcid) {
        return this.msgContext.getAttachment(blobcid);
    }
}

