/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.framework;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.JarInputStream;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.jaxws.framework.JAXWSDeployerSupport;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSDeployer
extends AbstractDeployer {
    private static Log log = LogFactory.getLog(JAXWSDeployer.class);
    protected ConfigurationContext configCtx;
    protected AxisConfiguration axisConfig;
    private String directory;

    public void init(ConfigurationContext configCtx) {
        this.configCtx = configCtx;
        this.axisConfig = configCtx.getAxisConfiguration();
        this.deployServicesInWARClassPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployServicesInWARClassPath() {
        String dir = DeploymentEngine.getWebLocationString();
        if (dir != null) {
            File file = new File(dir + "/WEB-INF/classes/");
            URL repository = this.axisConfig.getRepository();
            if (!file.isDirectory() || repository == null) {
                return;
            }
            ArrayList<String> classList = this.getClassesInWebInfDirectory(file);
            ClassLoader threadClassLoader = null;
            try {
                threadClassLoader = Thread.currentThread().getContextClassLoader();
                ArrayList<URL> urls = new ArrayList<URL>();
                urls.add(repository);
                String webLocation = DeploymentEngine.getWebLocationString();
                if (webLocation != null) {
                    urls.add(new File(webLocation).toURI().toURL());
                }
                ClassLoader classLoader = Utils.createClassLoader(urls, (ClassLoader)this.axisConfig.getSystemClassLoader(), (boolean)true, (File)((File)this.axisConfig.getParameterValue("artifactsDIR")), (boolean)this.axisConfig.isChildFirstClassLoading());
                Thread.currentThread().setContextClassLoader(classLoader);
                JAXWSDeployerSupport deployerSupport = new JAXWSDeployerSupport(this.configCtx, this.directory);
                deployerSupport.deployClasses("JAXWS-Builtin", file.toURI().toURL(), Thread.currentThread().getContextClassLoader(), classList);
            }
            catch (NoClassDefFoundError e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)Messages.getMessage((String)"deployingexception", (String)e.getMessage()), (Throwable)e);
                }
            }
            catch (Exception e) {
                log.info((Object)Messages.getMessage((String)"deployingexception", (String)e.getMessage()), (Throwable)e);
            }
            finally {
                if (threadClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(threadClassLoader);
                }
            }
        }
    }

    protected ArrayList<String> getClassesInWebInfDirectory(File file) {
        String filePath = file.getAbsolutePath();
        Collection files = FileUtils.listFiles((File)file, (String[])new String[]{"class"}, (boolean)true);
        ArrayList<String> classList = new ArrayList<String>();
        for (File f : files) {
            String fPath = f.getAbsolutePath();
            String fqcn = fPath.substring(filePath.length() + 1);
            fqcn = fqcn.substring(0, fqcn.length() - ".class".length());
            fqcn = fqcn.replace('/', '.');
            fqcn = fqcn.replace('\\', '.');
            classList.add(fqcn);
        }
        return classList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentFileData deploymentFileData) {
        ClassLoader threadClassLoader = null;
        try {
            threadClassLoader = Thread.currentThread().getContextClassLoader();
            String groupName = deploymentFileData.getName();
            URL location = deploymentFileData.getFile().toURI().toURL();
            if (JAXWSDeployer.isJar(deploymentFileData.getFile())) {
                log.info((Object)("Deploying artifact : " + deploymentFileData.getAbsolutePath()));
                ArrayList<URL> urls = new ArrayList<URL>();
                urls.add(deploymentFileData.getFile().toURL());
                urls.add(this.axisConfig.getRepository());
                this.addJaxwsLibs(urls, this.axisConfig.getRepository().getPath() + this.directory);
                String webLocation = DeploymentEngine.getWebLocationString();
                if (webLocation != null) {
                    urls.add(new File(webLocation).toURI().toURL());
                }
                ClassLoader classLoader = Utils.createClassLoader(urls, (ClassLoader)this.axisConfig.getSystemClassLoader(), (boolean)true, (File)((File)this.axisConfig.getParameterValue("artifactsDIR")), (boolean)this.axisConfig.isChildFirstClassLoading());
                Thread.currentThread().setContextClassLoader(classLoader);
                List classList = Utils.getListOfClasses((DeploymentFileData)deploymentFileData);
                JAXWSDeployerSupport deployerSupport = new JAXWSDeployerSupport(this.configCtx, this.directory);
                AxisServiceGroup serviceGroup = deployerSupport.deployClasses(groupName, location, classLoader, classList);
                if (serviceGroup == null) {
                    String msg = "Error while deploying JAX-WS jar: " + location.toString() + ". JAX-WS Service deployment failed.";
                    log.error((Object)msg);
                    this.axisConfig.getFaultyServices().put(deploymentFileData.getFile().getAbsolutePath(), msg);
                }
            }
            super.deploy(deploymentFileData);
        }
        catch (Throwable t) {
            log.debug((Object)Messages.getMessage((String)"stroringfaultyservice", (String)t.getMessage()), t);
            this.storeFaultyService(deploymentFileData, t);
        }
        finally {
            if (threadClassLoader != null) {
                Thread.currentThread().setContextClassLoader(threadClassLoader);
            }
        }
    }

    protected void storeFaultyService(DeploymentFileData deploymentFileData, Throwable t) {
        StringWriter errorWriter = new StringWriter();
        PrintWriter ptintWriter = new PrintWriter(errorWriter);
        t.printStackTrace(ptintWriter);
        String error = "Error:\n" + errorWriter.toString();
        this.axisConfig.getFaultyServices().put(deploymentFileData.getFile().getAbsolutePath(), error);
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public void setExtension(String extension) {
    }

    public void undeploy(String fileName) {
        String serviceHierarchy = Utils.getServiceHierarchy((String)fileName, (String)this.directory);
        fileName = serviceHierarchy + Utils.getShortFileName((String)fileName);
        try {
            AxisServiceGroup serviceGroup = this.axisConfig.removeServiceGroup(fileName);
            if (this.configCtx != null) {
                this.configCtx.removeServiceGroupContext(serviceGroup);
            }
            super.undeploy(fileName);
            log.info((Object)Messages.getMessage((String)"serviceremoved", (String)fileName));
        }
        catch (AxisFault axisFault) {
            log.debug((Object)Messages.getMessage((String)"faultyserviceremoval", (String)axisFault.getMessage()), (Throwable)axisFault);
            this.axisConfig.removeFaultyService(fileName);
        }
    }

    public static boolean isJar(File f) {
        try {
            JarInputStream jis = new JarInputStream(new FileInputStream(f));
            if (jis.getNextEntry() != null) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private void addJaxwsLibs(ArrayList<URL> urls, String jaxwsDepDirPath) throws Exception {
        File jaxwsDepDirLib = new File(jaxwsDepDirPath + File.separator + "lib");
        if (jaxwsDepDirLib.exists() && jaxwsDepDirLib.isDirectory()) {
            for (File file : jaxwsDepDirLib.listFiles()) {
                if (!file.isFile()) continue;
                try {
                    urls.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new Exception("Error while loading libraries from the 'lib' directory under jaxws deployment direcotry.", e);
                }
            }
        }
    }
}

