/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.utils.conn.logging;

import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.impl.nio.DefaultHttpClientIODispatch;
import org.apache.http.impl.nio.DefaultHttpServerIODispatch;
import org.apache.http.nio.NHttpClientEventHandler;
import org.apache.http.nio.NHttpConnectionFactory;
import org.apache.http.nio.NHttpServerEventHandler;
import org.apache.http.nio.reactor.ssl.SSLSetupHandler;
import org.apache.synapse.transport.utils.conn.SynapseNHttpClientConnectionFactory;
import org.apache.synapse.transport.utils.conn.SynapseNHttpSSLClientConnectionFactory;
import org.apache.synapse.transport.utils.conn.SynapseNHttpSSLServerConnectionFactory;
import org.apache.synapse.transport.utils.conn.SynapseNHttpServerConnectionFactory;
import org.apache.synapse.transport.utils.conn.logging.LoggingClientEventHandler;
import org.apache.synapse.transport.utils.conn.logging.LoggingServerEventHandler;

public class LoggingUtils {
    public static DefaultHttpServerIODispatch getServerIODispatch(NHttpServerEventHandler handler, ConnectionConfig config) {
        return new DefaultHttpServerIODispatch(LoggingUtils.decorate(handler), (NHttpConnectionFactory)new SynapseNHttpServerConnectionFactory(config));
    }

    public static DefaultHttpServerIODispatch getServerIODispatch(NHttpServerEventHandler handler, ConnectionConfig config, SSLContext sslContext, SSLSetupHandler sslSetupHandler) {
        return new DefaultHttpServerIODispatch(LoggingUtils.decorate(handler), (NHttpConnectionFactory)new SynapseNHttpSSLServerConnectionFactory(config, sslContext, sslSetupHandler));
    }

    public static DefaultHttpClientIODispatch getClientIODispatch(NHttpClientEventHandler handler, ConnectionConfig config) {
        return new DefaultHttpClientIODispatch(LoggingUtils.decorate(handler), (NHttpConnectionFactory)new SynapseNHttpClientConnectionFactory(config));
    }

    public static DefaultHttpClientIODispatch getClientIODispatch(NHttpClientEventHandler handler, ConnectionConfig config, SSLContext sslContext, SSLSetupHandler sslSetupHandler, Map<String, SSLContext> customContexts) {
        return new DefaultHttpClientIODispatch(LoggingUtils.decorate(handler), (NHttpConnectionFactory)new SynapseNHttpSSLClientConnectionFactory(config, sslContext, sslSetupHandler, customContexts));
    }

    private static NHttpClientEventHandler decorate(NHttpClientEventHandler handler) {
        Log log = LogFactory.getLog(handler.getClass());
        if (log.isDebugEnabled()) {
            handler = new LoggingClientEventHandler(handler);
        }
        return handler;
    }

    private static NHttpServerEventHandler decorate(NHttpServerEventHandler handler) {
        Log log = LogFactory.getLog(handler.getClass());
        if (log.isDebugEnabled()) {
            handler = new LoggingServerEventHandler(handler);
        }
        return handler;
    }
}

