/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.evaluators.config;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.evaluators.Evaluator;
import org.apache.synapse.commons.evaluators.EvaluatorException;
import org.apache.synapse.commons.evaluators.config.EvaluatorSerializer;
import org.apache.synapse.commons.evaluators.config.EvaluatorSerializerFinder;

public abstract class AbstractEvaluatorSerializer
implements EvaluatorSerializer {
    protected Log log = LogFactory.getLog(this.getClass());
    protected static final OMFactory fac = OMAbstractFactory.getOMFactory();
    protected static final OMNamespace nullNS = fac.createOMNamespace("", "");

    protected AbstractEvaluatorSerializer() {
    }

    protected void serializeChildren(OMElement parent, Evaluator[] childEvaluators) throws EvaluatorException {
        for (Evaluator evaluator : childEvaluators) {
            String name = evaluator.getName();
            EvaluatorSerializer serializer = EvaluatorSerializerFinder.getInstance().getSerializer(name);
            if (serializer == null) {
                String msg = "Couldn't find the serializer for evaliator: " + name;
                this.log.error((Object)msg);
                throw new EvaluatorException(msg);
            }
            serializer.serialize(parent, evaluator);
        }
    }

    protected void serializeChild(OMElement parenet, Evaluator child) throws EvaluatorException {
        EvaluatorSerializer serializer = EvaluatorSerializerFinder.getInstance().getSerializer(child.getName());
        if (serializer == null) {
            String msg = "Couldn't find the serializer for evaliator: " + child.getName();
            this.log.error((Object)msg);
            throw new EvaluatorException(msg);
        }
        serializer.serialize(parenet, child);
    }
}

