/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.amqp.pollingtask;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.amqp.AMQPTransportBuffers;
import org.apache.synapse.transport.amqp.AMQPTransportEndpoint;
import org.apache.synapse.transport.amqp.AMQPTransportException;
import org.apache.synapse.transport.amqp.AMQPTransportUtils;
import org.apache.synapse.transport.amqp.connectionfactory.AMQPTransportConnectionFactory;
import org.apache.synapse.transport.amqp.ha.AMQPTransportReconnectHandler;
import org.apache.synapse.transport.amqp.pollingtask.AMQPTransportPollingTask;

public class AMQPTransportPollingTaskFactory {
    private static Log log = LogFactory.getLog(AMQPTransportPollingTaskFactory.class);

    public static AMQPTransportPollingTask createPollingTaskForService(AxisService service, ScheduledExecutorService pool, AMQPTransportEndpoint endpoint, AMQPTransportConnectionFactory connectionFactory, AMQPTransportReconnectHandler haHandler) throws AxisFault {
        Boolean isBlockingMode;
        Boolean isQueueAutoDelete;
        Boolean isQueueRestricted;
        String queueName;
        String bindingKeyString;
        String consumerExchange;
        Boolean isInternalExchange;
        String exchangeType;
        Boolean isAutoDelete;
        Map<String, String> svcParam = AMQPTransportUtils.getServiceStringParameters(service.getParameters());
        Map<String, String> conFacParam = connectionFactory.getParameters();
        AMQPTransportPollingTask pt = new AMQPTransportPollingTask();
        pt.setServiceName(service.getName());
        pt.setEndpoint(endpoint);
        pt.setPollingTaskScheduler(pool);
        pt.setHaHandler(haHandler);
        pt.setBuffers(new AMQPTransportBuffers());
        String exchangeName = AMQPTransportUtils.getOptionalStringParameter("transport.amqp.ExchangeName", svcParam, conFacParam);
        pt.setExchangeName(exchangeName);
        Boolean isDurable = AMQPTransportUtils.getOptionalBooleanParameter("transport.amqp.IsExchangeDurable", svcParam, conFacParam);
        if (isDurable != null) {
            pt.setExchangeDurable(isDurable);
        }
        if ((isAutoDelete = AMQPTransportUtils.getOptionalBooleanParameter("transport.amqp.IsExchangeAutoDelete", svcParam, conFacParam)) != null) {
            pt.setExchangeAutoDelete(isAutoDelete);
        }
        if ((exchangeType = AMQPTransportUtils.getOptionalStringParameter("transport.amqp.ExchangeType", svcParam, conFacParam)) != null) {
            if (exchangeName == null) {
                throw new AxisFault("Possible configuration error. No exchange name provided but exchange type is set to '" + exchangeType + "'");
            }
            pt.setExchangeType(exchangeType);
        }
        if ((isInternalExchange = AMQPTransportUtils.getOptionalBooleanParameter("transport.amqp.ExchangeInternal", svcParam, conFacParam)) != null) {
            if (exchangeName == null) {
                throw new AxisFault("Possible configuration error. No exchange name provided but exchange restricted as " + (isInternalExchange != false ? "internal." : "external."));
            }
            pt.setInternalExchange(isInternalExchange);
        }
        pt.setChannel(connectionFactory.getChannel());
        pt.setConnectionFactoryName(connectionFactory.getName());
        String responseConFac = AMQPTransportUtils.getOptionalStringParameter("transport.amqp.ResponseConnectionFactoryName", svcParam, conFacParam);
        if (responseConFac != null) {
            pt.setResponseConnectionFactory(responseConFac);
        }
        if ((consumerExchange = AMQPTransportUtils.getOptionalStringParameter("transport.amqp.BindExchange", svcParam, conFacParam)) != null) {
            if (exchangeName != null && !consumerExchange.equals(exchangeName)) {
                log.warn((Object)("Possible configuration error? Exchange name is set to '" + exchangeName + "' and consumer's exchange name is set to '" + consumerExchange + "'"));
            }
            pt.setConsumerExchangeName(consumerExchange);
        }
        if ((bindingKeyString = AMQPTransportUtils.getOptionalStringParameter("transport.amqp.BindingKeys", svcParam, conFacParam)) != null) {
            pt.setBindingsKeys(AMQPTransportUtils.split(bindingKeyString, ","));
        }
        if ((queueName = AMQPTransportUtils.getOptionalStringParameter("transport.amqp.QueueName", svcParam, conFacParam)) == null) {
            queueName = service.getName();
        }
        pt.setQueueName(queueName);
        String configuredContentType = AMQPTransportUtils.getOptionalStringParameter("transport.amqp.ContentType", svcParam, conFacParam);
        if (configuredContentType != null) {
            pt.setConfiguredContentType(configuredContentType);
        }
        Boolean isQueueDurable = AMQPTransportUtils.getOptionalBooleanParameter("transport.amqp.IsQueueDurable", svcParam, conFacParam);
        if (isDurable != null) {
            pt.setQueueDurable(isQueueDurable);
        }
        if ((isQueueRestricted = AMQPTransportUtils.getOptionalBooleanParameter("transport.amqp.IsQueueRestricted", svcParam, conFacParam)) != null) {
            pt.setQueueRestricted(isQueueRestricted);
        }
        if ((isQueueAutoDelete = AMQPTransportUtils.getOptionalBooleanParameter("transport.amqp.IsQueueAutoDelete", svcParam, conFacParam)) != null) {
            pt.setQueueAutoDelete(isQueueAutoDelete);
        }
        if ((isBlockingMode = AMQPTransportUtils.getOptionalBooleanParameter("transport.amqp.OperateOnBlockingMode", svcParam, conFacParam)) != null) {
            pt.setBlockingMode(isBlockingMode);
        }
        try {
            Integer noOfConsumers = AMQPTransportUtils.getOptionalIntParameter("transport.amqp.NoOfConcurrentConsumers", svcParam, conFacParam);
            if (noOfConsumers != null) {
                pt.setNoOfConcurrentConsumers(noOfConsumers);
            }
        }
        catch (AMQPTransportException e) {
            throw new AxisFault("Could not assign the number of concurrent consumers", (Throwable)e);
        }
        try {
            Integer dispatchingTask = AMQPTransportUtils.getOptionalIntParameter("transport.amqp.NoOfDispatchingTask", svcParam, conFacParam);
            if (dispatchingTask != null) {
                pt.setNoOfDispatchingTask(dispatchingTask);
            }
        }
        catch (AMQPTransportException e) {
            throw new AxisFault("Could not assign number of dispatching task value", (Throwable)e);
        }
        Boolean isUseTx = AMQPTransportUtils.getOptionalBooleanParameter("transport.amqp.ConsumerTx", svcParam, conFacParam);
        if (isUseTx != null) {
            pt.setUseTx(isUseTx);
        }
        try {
            Integer initialDelay = AMQPTransportUtils.getOptionalIntParameter("transport.amqp.ScheduledTaskInitialDelay", svcParam, conFacParam);
            if (initialDelay != null) {
                pt.setScheduledTaskInitialDelay(initialDelay);
            }
        }
        catch (AMQPTransportException e) {
            throw new AxisFault("Could not assign the scheduled task initial delay value", (Throwable)e);
        }
        try {
            Integer delay = AMQPTransportUtils.getOptionalIntParameter("transport.amqp.ScheduledTaskInitialDelay", svcParam, conFacParam);
            if (delay != null) {
                pt.setScheduledTaskDelay(delay);
            }
        }
        catch (AMQPTransportException e) {
            throw new AxisFault("Could not assign the scheduled task delay value", (Throwable)e);
        }
        String timeUnit = AMQPTransportUtils.getOptionalStringParameter("transport.amqp.ScheduledTaskTimeUnit", svcParam, conFacParam);
        if (timeUnit != null) {
            pt.setScheduledTaskTimeUnit(AMQPTransportPollingTaskFactory.getTimeUnit(timeUnit));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("A polling task for the service '" + service.getName() + "' was produced with following parameters.\nExchange Name: '" + pt.getExchangeName() + "'\nExchange Type: '" + pt.getExchangeType() + "'\nExchange Durable?: '" + pt.isExchangeDurable() + "'\nExchange AutoDelete?: '" + pt.isExchangeAutoDelete() + "\nIs internal exchange: '" + pt.isInternalExchange() + "'\nConsumer Exchange: " + pt.getConsumerExchangeName() + "'\nRouting Keys: '" + bindingKeyString + "'\nQueueName: '" + pt.getQueueName() + "'\nIs queue durable: '" + pt.isQueueDurable() + "'\nIs queue restricted: '" + pt.isQueueRestricted() + "'\nIs queue auto deleted: '" + pt.isQueueAutoDelete() + "'\nIs blocking mode: '" + pt.isBlockingMode() + "'\nNumber of concurrent consumers: '" + pt.getNoOfConcurrentConsumers() + "'\nNumber of dispatching task: '" + pt.getNoOfDispatchingTask() + "'"));
        }
        return pt;
    }

    private static TimeUnit getTimeUnit(String timeUnit) {
        if ("days".equals(timeUnit)) {
            return TimeUnit.DAYS;
        }
        if ("hours".equals(timeUnit)) {
            return TimeUnit.HOURS;
        }
        if ("minutes".equals(timeUnit)) {
            return TimeUnit.MINUTES;
        }
        if ("seconds".equals(timeUnit)) {
            return TimeUnit.SECONDS;
        }
        if ("milliseconds".equals(timeUnit)) {
            return TimeUnit.MILLISECONDS;
        }
        return TimeUnit.MICROSECONDS;
    }
}

