/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.eip;

import org.apache.axis2.addressing.EndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.base.SequenceMediator;

public class Target {
    private static final Log log = LogFactory.getLog(Target.class);
    private String toAddress = null;
    private String soapAction = null;
    private SequenceMediator sequence = null;
    private String sequenceRef = null;
    private Endpoint endpoint = null;
    private String endpointRef = null;
    private boolean asynchronous = true;

    public boolean mediate(MessageContext synCtx) {
        boolean returnValue = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Target mediation : START");
        }
        if (this.soapAction != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting the SOAPAction as : " + this.soapAction));
            }
            synCtx.setSoapAction(this.soapAction);
        }
        if (this.toAddress != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting the To header as : " + this.toAddress));
            }
            if (synCtx.getTo() != null) {
                synCtx.getTo().setAddress(this.toAddress);
            } else {
                synCtx.setTo(new EndpointReference(this.toAddress));
            }
        }
        if (this.sequence != null) {
            if (this.asynchronous) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Asynchronously mediating using the in-lined anonymous sequence");
                }
                synCtx.getEnvironment().injectAsync(synCtx, this.sequence);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Synchronously mediating using the in-lined anonymous sequence");
                }
                returnValue = this.sequence.mediate(synCtx);
            }
        } else if (this.sequenceRef != null) {
            SequenceMediator refSequence = (SequenceMediator)synCtx.getSequence(this.sequenceRef);
            if (refSequence != null) {
                if (this.asynchronous) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Asynchronously mediating using the sequence named : " + this.sequenceRef));
                    }
                    synCtx.getEnvironment().injectAsync(synCtx, refSequence);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Synchronously mediating using the sequence named : " + this.sequenceRef));
                    }
                    returnValue = refSequence.mediate(synCtx);
                }
            } else {
                this.handleException("Couldn't find the sequence named : " + this.sequenceRef);
            }
        } else if (this.endpoint != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Sending using the in-lined anonymous endpoint");
            }
            this.endpoint.send(synCtx);
        } else if (this.endpointRef != null) {
            Endpoint epr = synCtx.getConfiguration().getEndpoint(this.endpointRef);
            if (epr != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending using the endpoint named : " + this.endpointRef));
                }
                epr.send(synCtx);
            } else {
                this.handleException("Couldn't find the endpoint named : " + this.endpointRef);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Target mediation : END");
        }
        return returnValue;
    }

    private void handleException(String message) {
        log.error((Object)message);
        throw new SynapseException(message);
    }

    public String getToAddress() {
        return this.toAddress;
    }

    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public SequenceMediator getSequence() {
        return this.sequence;
    }

    public void setSequence(SequenceMediator sequence) {
        this.sequence = sequence;
    }

    public String getSequenceRef() {
        return this.sequenceRef;
    }

    public void setSequenceRef(String sequenceRef) {
        this.sequenceRef = sequenceRef;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public String getEndpointRef() {
        return this.endpointRef;
    }

    public void setEndpointRef(String endpointRef) {
        this.endpointRef = endpointRef;
    }

    public void setAsynchronous(boolean asynchronous) {
        this.asynchronous = asynchronous;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }
}

