/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.jaxp;

import java.nio.charset.Charset;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.dom.DOMMetaFactory;
import org.apache.axiom.om.util.ElementHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.util.jaxp.ResultBuilder;
import org.w3c.dom.Document;

public class DOOMResultBuilder
implements ResultBuilder {
    private static final Log log = LogFactory.getLog(DOOMResultBuilder.class);
    private Document document;

    @Override
    public Result getResult() {
        DOMMetaFactory domMetaFactory = (DOMMetaFactory)OMAbstractFactory.getMetaFactory((String)"dom");
        try {
            this.document = domMetaFactory.newDocumentBuilderFactory().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            DOOMResultBuilder.handleException("Unable to create empty DOOM document", e);
        }
        return new DOMResult(this.document);
    }

    @Override
    public OMElement getNode(Charset charset) {
        if (this.document.getDocumentElement() != null) {
            return ElementHelper.importOMElement((OMElement)((OMElement)this.document.getDocumentElement()), (OMFactory)OMAbstractFactory.getOMFactory());
        }
        DOOMResultBuilder.handleException("Cannot find the Document Element");
        return null;
    }

    @Override
    public void release() {
    }

    private static void handleException(String message, Throwable ex) {
        log.error((Object)message, ex);
        throw new SynapseException(message, ex);
    }

    private static void handleException(String message) {
        log.error((Object)message);
        throw new SynapseException(message);
    }
}

