/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops;

import java.util.HashMap;
import java.util.Map;
import org.apache.sysml.conf.CompilerConfig;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.MemoTable;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.lops.Data;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;

public class DataOp
extends Hop {
    private Hop.DataOpTypes _dataop;
    private String _fileName = null;
    private Hop.FileFormatTypes _inFormat = Hop.FileFormatTypes.TEXT;
    private long _inRowsInBlock = -1L;
    private long _inColsInBlock = -1L;
    private boolean _recompileRead = true;
    private HashMap<String, Integer> _paramIndexMap = new HashMap();

    private DataOp() {
    }

    public DataOp(String l, Expression.DataType dt, Expression.ValueType vt, Hop.DataOpTypes dop, String fname, long dim1, long dim2, long nnz, int rowsPerBlock, int colsPerBlock) {
        super(l, dt, vt);
        this._dataop = dop;
        this._fileName = fname;
        this.setDim1(dim1);
        this.setDim2(dim2);
        this.setRowsInBlock(rowsPerBlock);
        this.setColsInBlock(colsPerBlock);
        this.setNnz(nnz);
        if (dop == Hop.DataOpTypes.TRANSIENTREAD) {
            this.setInputFormatType(Hop.FileFormatTypes.BINARY);
        }
    }

    public DataOp(String l, Expression.DataType dt, Expression.ValueType vt, Hop.DataOpTypes dop, String fname, long dim1, long dim2, long nnz, MatrixObject.UpdateType update, int rowsPerBlock, int colsPerBlock) {
        this(l, dt, vt, dop, fname, dim1, dim2, nnz, rowsPerBlock, colsPerBlock);
        this.setUpdateType(update);
    }

    public DataOp(String l, Expression.DataType dt, Expression.ValueType vt, Hop.DataOpTypes dop, HashMap<String, Hop> inputParameters) {
        super(l, dt, vt);
        this._dataop = dop;
        int index = 0;
        for (Map.Entry<String, Hop> e : inputParameters.entrySet()) {
            String s = e.getKey();
            Hop input = e.getValue();
            this.getInput().add(input);
            input.getParent().add(this);
            this._paramIndexMap.put(s, index);
            ++index;
        }
        if (dop == Hop.DataOpTypes.TRANSIENTREAD) {
            this.setInputFormatType(Hop.FileFormatTypes.BINARY);
        }
    }

    public DataOp(String l, Expression.DataType dt, Expression.ValueType vt, Hop in, Hop.DataOpTypes dop, String fname) {
        super(l, dt, vt);
        this._dataop = dop;
        this.getInput().add(0, in);
        in.getParent().add(this);
        this._fileName = fname;
        if (dop == Hop.DataOpTypes.TRANSIENTWRITE || dop == Hop.DataOpTypes.FUNCTIONOUTPUT) {
            this.setInputFormatType(Hop.FileFormatTypes.BINARY);
        }
    }

    public DataOp(String l, Expression.DataType dt, Expression.ValueType vt, Hop.DataOpTypes dop, Hop in, HashMap<String, Hop> inputParameters) {
        super(l, dt, vt);
        this._dataop = dop;
        this.getInput().add(0, in);
        in.getParent().add(this);
        if (inputParameters != null) {
            int index = 1;
            for (Map.Entry<String, Hop> e : inputParameters.entrySet()) {
                String s = e.getKey();
                Hop input = e.getValue();
                this.getInput().add(input);
                input.getParent().add(this);
                this._paramIndexMap.put(s, index);
                ++index;
            }
        }
        if (dop == Hop.DataOpTypes.TRANSIENTWRITE) {
            this.setInputFormatType(Hop.FileFormatTypes.BINARY);
        }
    }

    @Override
    public void checkArity() {
        int sz = this._input.size();
        int pz = this._paramIndexMap.size();
        switch (this._dataop) {
            case PERSISTENTREAD: 
            case TRANSIENTREAD: {
                HopsException.check(sz == pz, this, "in %s operator type has %d inputs and %d parameters", this._dataop.name(), sz, pz);
                break;
            }
            case PERSISTENTWRITE: 
            case TRANSIENTWRITE: 
            case FUNCTIONOUTPUT: {
                HopsException.check(sz == pz + 1, this, "in %s operator type has %d inputs and %d parameters (expect 1 more input for write operator type)", this._dataop.name(), sz, pz);
            }
        }
    }

    public Hop.DataOpTypes getDataOpType() {
        return this._dataop;
    }

    public void setDataOpType(Hop.DataOpTypes type) {
        this._dataop = type;
    }

    public void setOutputParams(long dim1, long dim2, long nnz, MatrixObject.UpdateType update, int rowsPerBlock, int colsPerBlock) {
        this.setDim1(dim1);
        this.setDim2(dim2);
        this.setNnz(nnz);
        this.setUpdateType(update);
        this.setRowsInBlock(rowsPerBlock);
        this.setColsInBlock(colsPerBlock);
    }

    public void setFileName(String fn) {
        this._fileName = fn;
    }

    public String getFileName() {
        return this._fileName;
    }

    public int getParameterIndex(String name) {
        return this._paramIndexMap.get(name);
    }

    @Override
    public boolean isGPUEnabled() {
        return false;
    }

    @Override
    public Lop constructLops() {
        if (this.getLops() != null) {
            return this.getLops();
        }
        LopProperties.ExecType et = this.optFindExecType();
        Data l = null;
        HashMap<String, Lop> inputLops = new HashMap<String, Lop>();
        for (Map.Entry<String, Integer> cur : this._paramIndexMap.entrySet()) {
            inputLops.put(cur.getKey(), this.getInput().get(cur.getValue()).constructLops());
        }
        switch (this._dataop) {
            case TRANSIENTREAD: {
                l = new Data((Data.OperationTypes)((Object)HopsData2Lops.get((Object)this._dataop)), null, inputLops, this.getName(), null, this.getDataType(), this.getValueType(), true, this.getInputFormatType());
                this.setOutputDimensions(l);
                break;
            }
            case PERSISTENTREAD: {
                l = new Data((Data.OperationTypes)((Object)HopsData2Lops.get((Object)this._dataop)), null, inputLops, this.getName(), null, this.getDataType(), this.getValueType(), false, this.getInputFormatType());
                l.getOutputParameters().setDimensions(this.getDim1(), this.getDim2(), this._inRowsInBlock, this._inColsInBlock, this.getNnz(), this.getUpdateType());
                break;
            }
            case PERSISTENTWRITE: {
                l = new Data((Data.OperationTypes)((Object)HopsData2Lops.get((Object)this._dataop)), this.getInput().get(0).constructLops(), inputLops, this.getName(), null, this.getDataType(), this.getValueType(), false, this.getInputFormatType());
                l.setExecType(et);
                this.setOutputDimensions(l);
                break;
            }
            case TRANSIENTWRITE: {
                l = new Data((Data.OperationTypes)((Object)HopsData2Lops.get((Object)this._dataop)), this.getInput().get(0).constructLops(), inputLops, this.getName(), null, this.getDataType(), this.getValueType(), true, this.getInputFormatType());
                this.setOutputDimensions(l);
                break;
            }
            case FUNCTIONOUTPUT: {
                l = new Data((Data.OperationTypes)((Object)HopsData2Lops.get((Object)this._dataop)), this.getInput().get(0).constructLops(), inputLops, this.getName(), null, this.getDataType(), this.getValueType(), true, this.getInputFormatType());
                l.setExecType(et);
                this.setOutputDimensions(l);
                break;
            }
            default: {
                throw new LopsException("Invalid operation type for Data LOP: " + (Object)((Object)this._dataop));
            }
        }
        this.setLineNumbers(l);
        this.setLops(l);
        this.constructAndSetLopsDataFlowProperties();
        return this.getLops();
    }

    public void setInputFormatType(Hop.FileFormatTypes ft) {
        this._inFormat = ft;
    }

    public Hop.FileFormatTypes getInputFormatType() {
        return this._inFormat;
    }

    public void setInputBlockSizes(long brlen, long bclen) {
        this.setInputRowsInBlock(brlen);
        this.setInputColsInBlock(bclen);
    }

    public void setInputRowsInBlock(long brlen) {
        this._inRowsInBlock = brlen;
    }

    public long getInputRowsInBlock() {
        return this._inRowsInBlock;
    }

    public void setInputColsInBlock(long bclen) {
        this._inColsInBlock = bclen;
    }

    public long getInputColsInBlock() {
        return this._inColsInBlock;
    }

    public boolean isRead() {
        return this._dataop == Hop.DataOpTypes.PERSISTENTREAD || this._dataop == Hop.DataOpTypes.TRANSIENTREAD;
    }

    public boolean isWrite() {
        return this._dataop == Hop.DataOpTypes.PERSISTENTWRITE || this._dataop == Hop.DataOpTypes.TRANSIENTWRITE;
    }

    public boolean isPersistentReadWrite() {
        return this._dataop == Hop.DataOpTypes.PERSISTENTREAD || this._dataop == Hop.DataOpTypes.PERSISTENTWRITE;
    }

    @Override
    public String getOpString() {
        String s = new String("");
        s = s + (String)HopsData2String.get((Object)this._dataop);
        s = s + " " + this.getName();
        return s;
    }

    @Override
    public boolean allowsAllExecTypes() {
        return false;
    }

    @Override
    protected double computeOutputMemEstimate(long dim1, long dim2, long nnz) {
        double ret = 0.0;
        if (this.getDataType() == Expression.DataType.SCALAR) {
            switch (this.getValueType()) {
                case INT: {
                    ret = 4.0;
                    break;
                }
                case DOUBLE: {
                    ret = 8.0;
                    break;
                }
                case BOOLEAN: {
                    ret = 1.0;
                    break;
                }
                case STRING: {
                    ret = 100.0;
                    break;
                }
                case OBJECT: {
                    ret = OptimizerUtils.DEFAULT_SIZE;
                    break;
                }
                default: {
                    ret = 0.0;
                    break;
                }
            }
        } else if (this._dataop == Hop.DataOpTypes.PERSISTENTREAD || this._dataop == Hop.DataOpTypes.TRANSIENTREAD) {
            double sparsity = OptimizerUtils.getSparsity(dim1, dim2, nnz);
            ret = OptimizerUtils.estimateSizeExactSparsity(dim1, dim2, sparsity);
        }
        return ret;
    }

    @Override
    protected double computeIntermediateMemEstimate(long dim1, long dim2, long nnz) {
        return 8192.0;
    }

    @Override
    protected long[] inferOutputCharacteristics(MemoTable memo) {
        MatrixCharacteristics mc;
        long[] ret = null;
        if (this._dataop == Hop.DataOpTypes.PERSISTENTWRITE || this._dataop == Hop.DataOpTypes.TRANSIENTWRITE) {
            MatrixCharacteristics mc2 = memo.getAllInputStats(this.getInput().get(0));
            if (mc2.dimsKnown()) {
                ret = new long[]{mc2.getRows(), mc2.getCols(), mc2.getNonZeros()};
            }
        } else if (this._dataop == Hop.DataOpTypes.TRANSIENTREAD && (mc = memo.getAllInputStats(this)).dimsKnown()) {
            ret = new long[]{mc.getRows(), mc.getCols(), mc.getNonZeros()};
        }
        return ret;
    }

    @Override
    protected LopProperties.ExecType optFindExecType() {
        LopProperties.ExecType REMOTE;
        LopProperties.ExecType letype = OptimizerUtils.isMemoryBasedOptLevel() ? this.findExecTypeByMemEstimate() : null;
        LopProperties.ExecType execType = REMOTE = OptimizerUtils.isSparkExecutionMode() ? LopProperties.ExecType.SPARK : LopProperties.ExecType.MR;
        if (this._dataop == Hop.DataOpTypes.PERSISTENTWRITE || this._dataop == Hop.DataOpTypes.TRANSIENTWRITE) {
            this.checkAndSetForcedPlatform();
            if (this.getDataType() == Expression.DataType.SCALAR || this.getDataType() == Expression.DataType.FRAME && REMOTE == LopProperties.ExecType.MR) {
                this._etypeForced = LopProperties.ExecType.CP;
            }
            if (this._etypeForced != null) {
                this._etype = this._etypeForced;
            } else {
                this._etype = OptimizerUtils.isMemoryBasedOptLevel() ? letype : (this.getInput().get(0).areDimsBelowThreshold() ? LopProperties.ExecType.CP : REMOTE);
                this.checkAndSetInvalidCPDimsAndSize();
            }
            this.setRequiresRecompileIfNecessary();
        } else {
            if (ConfigurationManager.isDynamicRecompilation() && !this.dimsKnown(true) && letype == REMOTE && (this._recompileRead || this._requiresCheckpoint)) {
                this.setRequiresRecompile();
            }
            this._etype = letype;
        }
        return this._etype;
    }

    @Override
    public void refreshSizeInformation() {
        if (this._dataop == Hop.DataOpTypes.PERSISTENTWRITE || this._dataop == Hop.DataOpTypes.TRANSIENTWRITE) {
            Hop input1 = this.getInput().get(0);
            this.setDim1(input1.getDim1());
            this.setDim2(input1.getDim2());
            this.setNnz(input1.getNnz());
        }
    }

    public void disableRecompileRead() {
        this._recompileRead = false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DataOp ret = new DataOp();
        ret.clone(this, false);
        ret._dataop = this._dataop;
        ret._fileName = this._fileName;
        ret._inFormat = this._inFormat;
        ret._inRowsInBlock = this._inRowsInBlock;
        ret._inColsInBlock = this._inColsInBlock;
        ret._recompileRead = this._recompileRead;
        ret._paramIndexMap = (HashMap)this._paramIndexMap.clone();
        return ret;
    }

    @Override
    public boolean compare(Hop that) {
        boolean ret;
        if (!(that instanceof DataOp)) {
            return false;
        }
        DataOp that2 = (DataOp)that;
        boolean bl = ret = OptimizerUtils.ALLOW_COMMON_SUBEXPRESSION_ELIMINATION && ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.ALLOW_CSE_PERSISTENT_READS) && this._dataop == that2._dataop && this._dataop == Hop.DataOpTypes.PERSISTENTREAD && this._fileName.equals(that2._fileName) && this._inFormat == that2._inFormat && this._inRowsInBlock == that2._inRowsInBlock && this._inColsInBlock == that2._inColsInBlock && this._paramIndexMap != null && that2._paramIndexMap != null;
        if (ret) {
            for (Map.Entry<String, Integer> e : this._paramIndexMap.entrySet()) {
                String key1 = e.getKey();
                int pos1 = e.getValue();
                int pos2 = that2._paramIndexMap.get(key1);
                ret &= that2.getInput().get(pos2) != null && this.getInput().get(pos1) == that2.getInput().get(pos2);
            }
        }
        return ret;
    }

    public void removeInput(String inputName) {
        int inputIndex = this.getParameterIndex(inputName);
        Hop tmp = (Hop)this._input.remove(inputIndex);
        tmp._parent.remove(this);
        this._paramIndexMap.remove(inputName);
        for (Map.Entry<String, Integer> entry : this._paramIndexMap.entrySet()) {
            if (entry.getValue() <= inputIndex) continue;
            this._paramIndexMap.put(entry.getKey(), entry.getValue() - 1);
        }
    }
}

