/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.compress.utils;

import java.util.Arrays;

public class IntArrayList {
    private static final int INIT_CAPACITY = 4;
    private static final int RESIZE_FACTOR = 2;
    private int[] _data = null;
    private int _size = 0;
    private int _val0 = -1;

    public IntArrayList() {
    }

    public IntArrayList(int value) {
        this();
        this.appendValue(value);
    }

    public int size() {
        return this._size;
    }

    public void appendValue(int value) {
        if (this._size == 0) {
            this._val0 = value;
            this._size = 1;
            return;
        }
        if (this._data == null) {
            this._data = new int[4];
            this._data[0] = this._val0;
        } else if (this._size + 1 >= this._data.length) {
            this.resize();
        }
        this._data[this._size] = value;
        ++this._size;
    }

    public int[] extractValues() {
        if (this._size == 1) {
            return new int[]{this._val0};
        }
        return this._data;
    }

    public int[] extractValues(boolean trim) {
        int[] ret = this.extractValues();
        return trim && this._size < ret.length ? Arrays.copyOfRange(ret, 0, this._size) : ret;
    }

    private void resize() {
        if (this._data.length > 0x3FFFFFFF) {
            throw new RuntimeException("IntArrayList resize leads to integer overflow: size=" + this._size);
        }
        this._data = Arrays.copyOf(this._data, this._data.length * 2);
    }
}

