/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor.mqo;

import java.util.HashMap;
import java.util.LinkedList;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.parfor.mqo.PiggybackingWorker;
import org.apache.sysml.runtime.controlprogram.parfor.mqo.PiggybackingWorkerTimeSequential;
import org.apache.sysml.runtime.controlprogram.parfor.mqo.PiggybackingWorkerUtilDecayParallel;
import org.apache.sysml.runtime.controlprogram.parfor.mqo.PiggybackingWorkerUtilTimeParallel;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysml.runtime.instructions.MRJobInstruction;
import org.apache.sysml.runtime.matrix.JobReturn;
import org.apache.sysml.runtime.matrix.data.Pair;

public class RuntimePiggybacking {
    private static PiggybackingType DEFAULT_WORKER_TYPE = PiggybackingType.UTIL_DECAY_BASED_PARALLEL;
    private static boolean _active = false;
    private static IDSequence _idSeq = null;
    private static PiggybackingWorker _worker = null;
    private static HashMap<JobType, LinkedList<Long>> _pool = null;
    private static HashMap<Long, MRJobInstruction> _jobs = null;

    public static boolean isActive() {
        return _active;
    }

    public static void start(int par) {
        RuntimePiggybacking.start(DEFAULT_WORKER_TYPE, par);
    }

    public static void start(PiggybackingType type, int par) {
        _active = true;
        switch (type) {
            case TIME_BASED_SEQUENTIAL: {
                _worker = new PiggybackingWorkerTimeSequential();
                break;
            }
            case UTIL_TIME_BASED_PARALLEL: {
                _worker = new PiggybackingWorkerUtilTimeParallel(par);
                break;
            }
            case UTIL_DECAY_BASED_PARALLEL: {
                _worker = new PiggybackingWorkerUtilDecayParallel(par);
                break;
            }
            default: {
                throw new DMLRuntimeException("Unsupported runtime piggybacking type: " + (Object)((Object)type));
            }
        }
        _worker.start();
    }

    public static void stop() {
        try {
            _active = false;
            _worker.setStopped();
            _worker.join();
            _worker = null;
        }
        catch (InterruptedException ex) {
            throw new DMLRuntimeException("Failed to stop runtime piggybacking server.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JobReturn submitJob(MRJobInstruction inst) {
        JobReturn ret = null;
        try {
            long id = _idSeq.getNextID();
            HashMap<JobType, LinkedList<Long>> hashMap = _pool;
            synchronized (hashMap) {
                if (!_pool.containsKey((Object)inst.getJobType())) {
                    _pool.put(inst.getJobType(), new LinkedList());
                }
                _pool.get((Object)inst.getJobType()).add(id);
                _jobs.put(id, inst);
            }
            ret = _worker.getJobResult(id);
            if (!ret.successful) {
                throw new DMLRuntimeException("Failed to run MR job via runtime piggybacking - job unsuccessful:\n" + inst.toString());
            }
        }
        catch (InterruptedException ex) {
            throw new DMLRuntimeException("Failed to submit MR job to runtime piggybacking server.", ex);
        }
        return ret;
    }

    public static boolean isSupportedJobType(JobType type) {
        return type == JobType.GMR || type == JobType.CM_COV || type == JobType.GROUPED_AGG || type == JobType.REBLOCK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static LinkedList<Pair<Long, MRJobInstruction>> getMaxWorkingSet() {
        LinkedList<Pair<Long, MRJobInstruction>> ret = null;
        HashMap<JobType, LinkedList<Long>> hashMap = _pool;
        synchronized (hashMap) {
            JobType currType = null;
            int currLength = 0;
            for (JobType jt : _pool.keySet()) {
                LinkedList<Long> tmp = _pool.get((Object)jt);
                if (tmp == null || currLength >= tmp.size()) continue;
                currLength = tmp.size();
                currType = jt;
            }
            if (currType == null) {
                return null;
            }
            ret = new LinkedList<Pair<Long, MRJobInstruction>>();
            LinkedList<Long> tmp = _pool.remove((Object)currType);
            for (Long id : tmp) {
                ret.add(new Pair<Long, MRJobInstruction>(id, _jobs.get(id)));
            }
        }
        return ret;
    }

    public static boolean isEmptyJobPool() {
        return _pool.isEmpty();
    }

    static {
        _pool = new HashMap();
        _jobs = new HashMap();
        _idSeq = new IDSequence();
    }

    public static enum PiggybackingType {
        TIME_BASED_SEQUENTIAL,
        UTIL_TIME_BASED_PARALLEL,
        UTIL_DECAY_BASED_PARALLEL;

    }
}

