/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;
import org.apache.sysml.runtime.instructions.spark.UnarySPInstruction;
import org.apache.sysml.runtime.instructions.spark.utils.FrameRDDConverterUtils;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.util.UtilFunctions;

public class CastSPInstruction
extends UnarySPInstruction {
    private CastSPInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String istr) {
        super(SPInstruction.SPType.Cast, op, in, out, opcode, istr);
    }

    public static CastSPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 2);
        String opcode = parts[0];
        CPOperand in = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        return new CastSPInstruction(null, in, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        String opcode = this.getOpcode();
        JavaPairRDD<?, ?> in = sec.getRDDHandleForVariable(this.input1.getName(), InputInfo.BinaryBlockInputInfo, -1, true);
        MatrixCharacteristics mcIn = sec.getMatrixCharacteristics(this.input1.getName());
        Object out = null;
        if (opcode.equals("castdtm")) {
            MatrixCharacteristics mcOut = new MatrixCharacteristics(mcIn);
            mcOut.setBlockSize(ConfigurationManager.getBlocksize(), ConfigurationManager.getBlocksize());
            out = FrameRDDConverterUtils.binaryBlockToMatrixBlock(in, mcIn, mcOut);
        } else if (opcode.equals("castdtf")) {
            out = FrameRDDConverterUtils.matrixBlockToBinaryBlockLongIndex(sec.getSparkContext(), in, mcIn);
        } else {
            throw new DMLRuntimeException("Unsupported spark cast operation: " + opcode);
        }
        sec.setRDDHandleForVariable(this.output.getName(), (JavaPairRDD<?, ?>)out);
        this.updateUnaryOutputMatrixCharacteristics(sec, this.input1.getName(), this.output.getName());
        sec.addLineageRDD(this.output.getName(), this.input1.getName());
        if (opcode.equals("castdtf")) {
            sec.getFrameObject(this.output.getName()).setSchema(UtilFunctions.nCopies((int)mcIn.getCols(), Expression.ValueType.DOUBLE));
        }
    }
}

