/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.runtime.instructions.mr.GroupedAggregateInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.TaggedMatrixIndexes;
import org.apache.sysml.runtime.matrix.data.WeightedCell;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.matrix.mapred.MapperBase;
import org.apache.sysml.runtime.matrix.operators.AggregateOperator;

public class GroupedAggMRMapper
extends MapperBase
implements Mapper<MatrixIndexes, MatrixValue, TaggedMatrixIndexes, WeightedCell> {
    protected ArrayList<ArrayList<GroupedAggregateInstruction>> groupAgg_instructions = new ArrayList();
    private MatrixIndexes outKeyValue = new MatrixIndexes();
    private TaggedMatrixIndexes outKey = new TaggedMatrixIndexes(this.outKeyValue, 0);
    private WeightedCell outValue = new WeightedCell();

    public void map(MatrixIndexes key, MatrixValue value, OutputCollector<TaggedMatrixIndexes, WeightedCell> out, Reporter reporter) throws IOException {
        for (int k = 0; k < this.representativeMatrixes.size(); ++k) {
            for (GroupedAggregateInstruction ins : this.groupAgg_instructions.get(k)) {
                this.outKey.setTag(ins.output);
                MatrixBlock block = (MatrixBlock)value;
                int rlen = block.getNumRows();
                int clen = block.getNumColumns();
                if (!ins.hasWeights()) {
                    long coloff = (key.getColumnIndex() - 1L) * ins.getBclen();
                    if (ins.getOperator() instanceof AggregateOperator && ins.getNGroups() > 0 && OptimizerUtils.isValidCPDimensions(ins.getNGroups(), block.getNumColumns() - 1)) {
                        try {
                            MatrixBlock group = block.slice(0, block.getNumRows() - 1, block.getNumColumns() - 1, block.getNumColumns() - 1, new MatrixBlock());
                            MatrixBlock target = block.slice(0, block.getNumRows() - 1, 0, block.getNumColumns() - 2, new MatrixBlock());
                            MatrixBlock tmp = group.groupedAggOperations(target, null, new MatrixBlock(), ins.getNGroups(), ins.getOperator());
                            for (int i = 0; i < tmp.getNumRows(); ++i) {
                                for (int j = 0; j < tmp.getNumColumns(); ++j) {
                                    double tmpval = tmp.quickGetValue(i, j);
                                    if (tmpval == 0.0) continue;
                                    this.outKeyValue.setIndexes(i + 1, coloff + (long)j + 1L);
                                    this.outValue.setValue(tmpval);
                                    this.outValue.setWeight(1.0);
                                    out.collect((Object)this.outKey, (Object)this.outValue);
                                }
                            }
                            continue;
                        }
                        catch (Exception ex) {
                            throw new IOException(ex);
                        }
                    }
                    for (int r = 0; r < rlen; ++r) {
                        int group = (int)block.quickGetValue(r, clen - 1);
                        for (int c = 0; c < clen - 1; ++c) {
                            this.outKeyValue.setIndexes(group, coloff + (long)c + 1L);
                            this.outValue.setValue(block.quickGetValue(r, c));
                            this.outValue.setWeight(1.0);
                            out.collect((Object)this.outKey, (Object)this.outValue);
                        }
                    }
                    continue;
                }
                for (int r = 0; r < rlen; ++r) {
                    this.outKeyValue.setIndexes((int)block.quickGetValue(r, 1), 1L);
                    this.outValue.setValue(block.quickGetValue(r, 0));
                    this.outValue.setWeight(block.quickGetValue(r, 2));
                    out.collect((Object)this.outKey, (Object)this.outValue);
                }
            }
        }
    }

    @Override
    protected void specialOperationsForActualMap(int index, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
    }

    @Override
    public void configure(JobConf job) {
        super.configure(job);
        try {
            GroupedAggregateInstruction[] grpaggIns = MRJobConfiguration.getGroupedAggregateInstructions(job);
            if (grpaggIns == null) {
                throw new RuntimeException("no GroupAggregate Instructions found!");
            }
            ArrayList<GroupedAggregateInstruction> vec = new ArrayList<GroupedAggregateInstruction>();
            for (int i = 0; i < this.representativeMatrixes.size(); ++i) {
                byte input = (Byte)this.representativeMatrixes.get(i);
                for (GroupedAggregateInstruction ins : grpaggIns) {
                    if (ins.input != input) continue;
                    vec.add(ins);
                }
                this.groupAgg_instructions.add(vec);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

