/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.sort;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;

public class ReadWithZeros {
    private boolean contain0s = false;
    private long numZeros = 0L;
    private FSDataInputStream currentStream;
    private DoubleWritable keyAfterZero = new DoubleWritable();
    private IntWritable valueAfterZero = new IntWritable();
    private boolean justFound0 = false;

    public ReadWithZeros(FSDataInputStream in, boolean contain0, long num0) {
        this.currentStream = in;
        this.contain0s = contain0;
        this.numZeros = num0;
    }

    public boolean readNextKeyValuePairs(DoubleWritable readKey, IntWritable readValue) throws IOException {
        boolean ret = true;
        try {
            if (this.contain0s && this.justFound0) {
                readKey.set(this.keyAfterZero.get());
                readValue.set(this.valueAfterZero.get());
                this.contain0s = false;
            } else {
                readKey.readFields((DataInput)this.currentStream);
                readValue.readFields((DataInput)this.currentStream);
            }
        }
        catch (EOFException e) {
            if (this.contain0s && !this.justFound0) {
                this.justFound0 = true;
                readKey.set(0.0);
                readValue.set((int)this.numZeros);
            }
            ret = false;
        }
        if (this.contain0s && !this.justFound0 && readKey.get() >= 0.0) {
            this.justFound0 = true;
            this.keyAfterZero.set(readKey.get());
            this.valueAfterZero.set(readValue.get());
            readKey.set(0.0);
            readValue.set((int)this.numZeros);
        }
        return ret;
    }
}

