#-------------------------------------------------------------
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
# 
#   http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
#-------------------------------------------------------------

args<-commandArgs(TRUE)
options(digits=22)
library("Matrix")
library("matrixStats")

X = matrix(seq(1,6000), 600, 10, byrow=TRUE)/6000;
ssX_V = matrix(seq(1,40), 10, 4, byrow=TRUE)/40;
P = matrix(seq(1,3000), 600, 5, byrow=TRUE)/3000;
K = 4;

Q = P[,1:K] * (X %*% ssX_V);
R = t(X) %*% (Q - P[,1:K] * rowSums(Q)%*%matrix(1,1,K));

writeMM(as(R, "CsparseMatrix"), paste(args[2], "S", sep="")); 
