/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated.monitoring.controllers;

import io.netty.handler.codec.http.FullHttpResponse;
import java.util.List;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.controllers.IController;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.BaseEntityModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.Request;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.Response;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.services.CoordinatorService;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.services.MapperService;

public class CoordinatorController
implements IController {
    private final CoordinatorService _coordinatorService = new CoordinatorService();

    @Override
    public FullHttpResponse create(Request request) {
        BaseEntityModel model = MapperService.getModelFromBody(request);
        this._coordinatorService.create(model);
        return Response.ok("Success");
    }

    @Override
    public FullHttpResponse update(Request request, Long objectId) {
        BaseEntityModel model = MapperService.getModelFromBody(request);
        this._coordinatorService.update(model);
        return Response.ok("Success");
    }

    @Override
    public FullHttpResponse delete(Request request, Long objectId) {
        this._coordinatorService.remove(objectId);
        return Response.ok("Success");
    }

    @Override
    public FullHttpResponse get(Request request, Long objectId) {
        BaseEntityModel result = this._coordinatorService.get(objectId);
        if (result == null) {
            return Response.notFound("No such coordinator can be found");
        }
        return Response.ok(result.toString());
    }

    @Override
    public FullHttpResponse getAll(Request request) {
        List<BaseEntityModel> coordinators = this._coordinatorService.getAll();
        if (coordinators.isEmpty()) {
            return Response.notFound("No coordinators can be found");
        }
        return Response.ok(coordinators.toString());
    }
}

