/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.columns;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;
import org.apache.sysds.runtime.frame.data.columns.BitSetArray;
import org.apache.sysds.runtime.frame.data.columns.BooleanArray;
import org.apache.sysds.runtime.frame.data.columns.CharArray;
import org.apache.sysds.runtime.frame.data.columns.DoubleArray;
import org.apache.sysds.runtime.frame.data.columns.FloatArray;
import org.apache.sysds.runtime.frame.data.columns.IntegerArray;
import org.apache.sysds.runtime.frame.data.columns.LongArray;
import org.apache.sysds.runtime.frame.data.lib.FrameUtil;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.transform.encode.ColumnEncoderRecode;
import org.apache.sysds.utils.MemoryEstimates;

public class StringArray
extends Array<String> {
    private String[] _data;
    private long materializedSize = -1L;

    public StringArray(String[] data) {
        super(data.length);
        this._data = data;
    }

    private StringArray(String[] data, long materializedSize) {
        this(data);
        this.materializedSize = materializedSize;
    }

    public String[] get() {
        return this._data;
    }

    @Override
    public String get(int index) {
        return this._data[index];
    }

    @Override
    public void set(int index, String value) {
        this._data[index] = value;
        this.materializedSize = -1L;
    }

    @Override
    public void set(int index, double value) {
        this._data[index] = Double.toString(value);
        this.materializedSize = -1L;
    }

    @Override
    public void set(int rl, int ru, Array<String> value) {
        this.set(rl, ru, value, 0);
        this.materializedSize = -1L;
    }

    @Override
    public void setFromOtherType(int rl, int ru, Array<?> value) {
        for (int i = rl; i <= ru; ++i) {
            Object v = value.get(i);
            this._data[i] = v != null ? v.toString() : null;
        }
        this.materializedSize = -1L;
    }

    @Override
    public void set(int rl, int ru, Array<String> value, int rlSrc) {
        System.arraycopy(((StringArray)value)._data, rlSrc, this._data, rl, ru - rl + 1);
        this.materializedSize = -1L;
    }

    @Override
    public void setNz(int rl, int ru, Array<String> value) {
        String[] data2 = ((StringArray)value)._data;
        for (int i = rl; i <= ru; ++i) {
            if (data2[i] == null) continue;
            this._data[i] = data2[i];
        }
        this.materializedSize = -1L;
    }

    @Override
    public void setFromOtherTypeNz(int rl, int ru, Array<?> value) {
        for (int i = rl; i <= ru; ++i) {
            Object v = value.get(i);
            if (v == null) continue;
            this._data[i] = v.toString();
        }
        this.materializedSize = -1L;
    }

    @Override
    public void append(String value) {
        if (this._data.length <= this._size) {
            this._data = Arrays.copyOf(this._data, this.newSize());
        }
        this._data[this._size++] = value;
        this.materializedSize = -1L;
    }

    @Override
    public Array<String> append(Array<String> other) {
        int endSize = this._size + other.size();
        String[] ret = new String[endSize];
        System.arraycopy(this._data, 0, ret, 0, this._size);
        System.arraycopy((String[])other.get(), 0, ret, this._size, other.size());
        return new StringArray(ret);
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(ArrayFactory.FrameArrayType.STRING.ordinal());
        out.writeLong(this.getInMemorySize());
        for (int i = 0; i < this._size; ++i) {
            out.writeUTF(this._data[i] != null ? this._data[i] : "");
        }
    }

    public void readFields(DataInput in) throws IOException {
        this._size = this._data.length;
        this.materializedSize = in.readLong();
        for (int i = 0; i < this._size; ++i) {
            String tmp = in.readUTF();
            this._data[i] = !tmp.isEmpty() ? tmp : null;
        }
    }

    @Override
    public Array<String> clone() {
        return new StringArray(Arrays.copyOf(this._data, this._size), this.materializedSize);
    }

    @Override
    public Array<String> slice(int rl, int ru) {
        return new StringArray(Arrays.copyOfRange(this._data, rl, ru));
    }

    @Override
    public void reset(int size) {
        if (this._data.length < size || this._data.length > 2 * size) {
            this._data = new String[size];
        } else {
            for (int i = 0; i < size; ++i) {
                this._data[i] = null;
            }
        }
        this._size = size;
        this.materializedSize = -1L;
    }

    @Override
    public byte[] getAsByteArray() {
        throw new NotImplementedException("Not Implemented getAsByte for string");
    }

    public byte[] getIndexAsBytes(int r) {
        if (this._data[r] != null) {
            return this._data[r].getBytes();
        }
        return null;
    }

    @Override
    public Types.ValueType getValueType() {
        return Types.ValueType.STRING;
    }

    private static final Types.ValueType getHighest(Types.ValueType state, Types.ValueType c) {
        switch (state) {
            case FP32: {
                switch (c) {
                    case FP64: {
                        return c;
                    }
                }
                break;
            }
            case INT64: {
                switch (c) {
                    case FP64: 
                    case FP32: {
                        return c;
                    }
                }
                break;
            }
            case INT32: {
                switch (c) {
                    case FP64: 
                    case FP32: 
                    case INT64: {
                        return c;
                    }
                }
                break;
            }
            case BOOLEAN: {
                switch (c) {
                    case FP64: 
                    case FP32: 
                    case INT64: 
                    case INT32: 
                    case CHARACTER: {
                        return c;
                    }
                }
                break;
            }
            case UNKNOWN: {
                return c;
            }
        }
        return state;
    }

    @Override
    public Pair<Types.ValueType, Boolean> analyzeValueType() {
        Types.ValueType state = Types.ValueType.UNKNOWN;
        boolean nulls = false;
        for (int i = 0; i < this._size; ++i) {
            Types.ValueType c = FrameUtil.isType(this._data[i], state);
            if (c == Types.ValueType.STRING) {
                return new Pair<Types.ValueType, Boolean>(Types.ValueType.STRING, false);
            }
            if (c == Types.ValueType.UNKNOWN) {
                nulls = true;
                continue;
            }
            state = StringArray.getHighest(state, c);
        }
        return new Pair<Types.ValueType, Boolean>(state, nulls);
    }

    @Override
    public ArrayFactory.FrameArrayType getFrameArrayType() {
        return ArrayFactory.FrameArrayType.STRING;
    }

    @Override
    public BitSetArray getNulls() {
        BitSetArray n = new BitSetArray(this._size);
        for (int i = 0; i < this._size; ++i) {
            if (this._data[i] == null) continue;
            n.set(i, true);
        }
        return n;
    }

    @Override
    public long getInMemorySize() {
        if (this.materializedSize != -1L) {
            return this.materializedSize;
        }
        long size = super.getInMemorySize();
        size = (long)((double)size + MemoryEstimates.stringArrayCost(this._data));
        this.materializedSize = size += 8L;
        return this.materializedSize;
    }

    @Override
    public long getExactSerializedSize() {
        long si = 9L;
        for (String s : this._data) {
            si += (long)IOUtilFunctions.getUTFSize(s);
        }
        return si;
    }

    @Override
    protected Array<Boolean> changeTypeBitSet() {
        return this.changeTypeBoolean();
    }

    @Override
    protected Array<Boolean> changeTypeBoolean() {
        String firstNN = this._data[0];
        int i = 1;
        while (firstNN == null && i < this.size()) {
            firstNN = this._data[i++];
        }
        if (i == this.size()) {
            return ArrayFactory.allocateBoolean(this.size());
        }
        if (firstNN.toLowerCase().equals("true") || firstNN.toLowerCase().equals("false")) {
            return this.changeTypeBooleanStandard();
        }
        if (firstNN.equals("0") || firstNN.equals("1")) {
            return this.changeTypeBooleanNumeric();
        }
        if (firstNN.equals("0.0") || firstNN.equals("1.0")) {
            return this.changeTypeBooleanFloat();
        }
        if (firstNN.toLowerCase().equals("t") || firstNN.toLowerCase().equals("f")) {
            return this.changeTypeBooleanCharacter();
        }
        throw new DMLRuntimeException("Not supported type of Strings to change to Booleans value: " + firstNN);
    }

    protected Array<Boolean> changeTypeBooleanStandard() {
        if (this.size() > 64) {
            return this.changeTypeBooleanStandardBitSet();
        }
        return this.changeTypeBooleanStandardArray();
    }

    protected Array<Boolean> changeTypeBooleanStandardBitSet() {
        BitSet ret = new BitSet(this.size());
        for (int i = 0; i < this.size(); ++i) {
            String s = this._data[i];
            if (s == null) continue;
            ret.set(i, Boolean.parseBoolean(this._data[i]));
        }
        return new BitSetArray(ret, this.size());
    }

    protected Array<Boolean> changeTypeBooleanStandardArray() {
        boolean[] ret = new boolean[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            String s = this._data[i];
            if (s == null) continue;
            ret[i] = Boolean.parseBoolean(this._data[i]);
        }
        return new BooleanArray(ret);
    }

    protected Array<Boolean> changeTypeBooleanCharacter() {
        if (this.size() > 64) {
            return this.changeTypeBooleanCharacterBitSet();
        }
        return this.changeTypeBooleanCharacterArray();
    }

    protected Array<Boolean> changeTypeBooleanCharacterBitSet() {
        BitSet ret = new BitSet(this.size());
        for (int i = 0; i < this.size(); ++i) {
            String s = this._data[i];
            if (s == null) continue;
            ret.set(i, this.isTrueCharacter(this._data[i].charAt(0)));
        }
        return new BitSetArray(ret, this.size());
    }

    protected Array<Boolean> changeTypeBooleanCharacterArray() {
        boolean[] ret = new boolean[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            String s = this._data[i];
            if (s == null) continue;
            ret[i] = this.isTrueCharacter(this._data[i].charAt(0));
        }
        return new BooleanArray(ret);
    }

    private boolean isTrueCharacter(char a) {
        return a == 'T' || a == 't';
    }

    protected Array<Boolean> changeTypeBooleanNumeric() {
        if (this.size() > 64) {
            return this.changeTypeBooleanNumericBitSet();
        }
        return this.changeTypeBooleanNumericArray();
    }

    protected Array<Boolean> changeTypeBooleanNumericBitSet() {
        BitSet ret = new BitSet(this.size());
        for (int i = 0; i < this.size(); ++i) {
            boolean one;
            String s = this._data[i];
            if (s == null) continue;
            boolean zero = this._data[i].equals("0");
            if (zero | (one = this._data[i].equals("1"))) {
                ret.set(i, one);
                continue;
            }
            throw new DMLRuntimeException("Unable to change to Boolean from String array, value:" + this._data[i]);
        }
        return new BitSetArray(ret, this.size());
    }

    protected Array<Boolean> changeTypeBooleanNumericArray() {
        boolean[] ret = new boolean[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            boolean one;
            String s = this._data[i];
            if (s == null) continue;
            boolean zero = this._data[i].equals("0");
            if (zero | (one = this._data[i].equals("1"))) {
                ret[i] = one;
                continue;
            }
            throw new DMLRuntimeException("Unable to change to Boolean from String array, value:" + this._data[i]);
        }
        return new BooleanArray(ret);
    }

    protected Array<Boolean> changeTypeBooleanFloat() {
        if (this.size() > 64) {
            return this.changeTypeBooleanFloatBitSet();
        }
        return this.changeTypeBooleanFloatArray();
    }

    protected Array<Boolean> changeTypeBooleanFloatBitSet() {
        BitSet ret = new BitSet(this.size());
        for (int i = 0; i < this.size(); ++i) {
            boolean one;
            String s = this._data[i];
            if (s == null) continue;
            boolean zero = this._data[i].equals("0.0");
            if (zero | (one = this._data[i].equals("1.0"))) {
                ret.set(i, one);
                continue;
            }
            throw new DMLRuntimeException("Unable to change to Boolean from String array, value:" + this._data[i]);
        }
        return new BitSetArray(ret, this.size());
    }

    protected Array<Boolean> changeTypeBooleanFloatArray() {
        boolean[] ret = new boolean[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            boolean one;
            String s = this._data[i];
            if (s == null) continue;
            boolean zero = this._data[i].equals("0.0");
            if (zero | (one = this._data[i].equals("1.0"))) {
                ret[i] = one;
                continue;
            }
            throw new DMLRuntimeException("Unable to change to Boolean from String array, value:" + this._data[i]);
        }
        return new BooleanArray(ret);
    }

    @Override
    protected Array<Double> changeTypeDouble() {
        try {
            double[] ret = new double[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                String s = this._data[i];
                if (s == null) continue;
                ret[i] = Double.parseDouble(s);
            }
            return new DoubleArray(ret);
        }
        catch (NumberFormatException e) {
            throw new DMLRuntimeException("Unable to change to Double from String array", e);
        }
    }

    @Override
    protected Array<Float> changeTypeFloat() {
        try {
            float[] ret = new float[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                String s = this._data[i];
                if (s == null) continue;
                ret[i] = Float.parseFloat(s);
            }
            return new FloatArray(ret);
        }
        catch (NumberFormatException e) {
            throw new DMLRuntimeException("Unable to change to Float from String array", e);
        }
    }

    @Override
    protected Array<Integer> changeTypeInteger() {
        try {
            int[] ret = new int[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                String s = this._data[i];
                if (s == null) continue;
                ret[i] = Integer.parseInt(s);
            }
            return new IntegerArray(ret);
        }
        catch (NumberFormatException e) {
            throw new DMLRuntimeException("Unable to change to Integer from String array", e);
        }
    }

    @Override
    protected Array<Long> changeTypeLong() {
        try {
            long[] ret = new long[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                String s = this._data[i];
                if (s == null) continue;
                ret[i] = Long.parseLong(s);
            }
            return new LongArray(ret);
        }
        catch (NumberFormatException e) {
            throw new DMLRuntimeException("Unable to change to Long from String array", e);
        }
    }

    @Override
    public Array<Character> changeTypeCharacter() {
        char[] ret = new char[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            if (this._data[i] == null) continue;
            ret[i] = this._data[i].charAt(0);
        }
        return new CharArray(ret);
    }

    @Override
    public Array<String> changeTypeString() {
        return this;
    }

    @Override
    public Pair<Integer, Integer> getMinMaxLength() {
        int minLength = Integer.MAX_VALUE;
        int maxLength = 0;
        for (int i = 0; i < this._size; ++i) {
            if (this._data[i] == null) continue;
            int l = this._data[i].length();
            minLength = minLength < l ? minLength : l;
            maxLength = maxLength > l ? maxLength : l;
        }
        return new Pair<Integer, Integer>(minLength, maxLength);
    }

    @Override
    public void fill(String value) {
        Arrays.fill(this._data, value);
        this.materializedSize = -1L;
    }

    @Override
    public double getAsDouble(int i) {
        return this._data[i] != null && !this._data[i].isEmpty() ? DoubleArray.parseDouble(this._data[i]) : 0.0;
    }

    @Override
    public double getAsNaNDouble(int i) {
        return this._data[i] != null && !this._data[i].isEmpty() ? DoubleArray.parseDouble(this._data[i]) : Double.NaN;
    }

    @Override
    public boolean isShallowSerialize() {
        long s = this.getInMemorySize();
        return this._size < 100 || s / (long)this._size < 100L;
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this._data.length; ++i) {
            if (this._data[i] == null || this._data[i].equals("0")) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsNull() {
        for (int i = 0; i < this._data.length; ++i) {
            if (this._data[i] != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Array<String> select(int[] indices) {
        String[] ret = new String[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            ret[i] = this._data[indices[i]];
        }
        return new StringArray(ret);
    }

    @Override
    public Array<String> select(boolean[] select, int nTrue) {
        String[] ret = new String[nTrue];
        int k = 0;
        for (int i = 0; i < select.length; ++i) {
            if (!select[i]) continue;
            ret[k++] = this._data[i];
        }
        return new StringArray(ret);
    }

    @Override
    public final boolean isNotEmpty(int i) {
        return this._data[i] != null && !this._data[i].equals("0");
    }

    @Override
    protected HashMap<String, Long> createRecodeMap() {
        try {
            String val;
            HashMap<String, Long> map = new HashMap<String, Long>();
            for (int i = 0; i < this.size() && (val = this.get(i)) != null; ++i) {
                String[] tmp = ColumnEncoderRecode.splitRecodeMapEntry(val.toString());
                map.put(tmp[0], Long.parseLong(tmp[1]));
            }
            return map;
        }
        catch (Exception e) {
            return super.createRecodeMap();
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this._size * 5 + 2);
        sb.append(super.toString() + ":[");
        for (int i = 0; i < this._size - 1; ++i) {
            sb.append(this._data[i] + ",");
        }
        sb.append(this._data[this._size - 1]);
        sb.append("]");
        return sb.toString();
    }
}

