/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.encode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.transform.TfUtils;
import org.apache.sysds.runtime.transform.encode.ColumnEncoder;
import org.apache.sysds.runtime.transform.encode.ColumnEncoderBin;
import org.apache.sysds.runtime.transform.encode.ColumnEncoderComposite;
import org.apache.sysds.runtime.transform.encode.ColumnEncoderDummycode;
import org.apache.sysds.runtime.transform.encode.ColumnEncoderFeatureHash;
import org.apache.sysds.runtime.transform.encode.ColumnEncoderPassThrough;
import org.apache.sysds.runtime.transform.encode.ColumnEncoderRecode;
import org.apache.sysds.runtime.transform.encode.ColumnEncoderUDF;
import org.apache.sysds.runtime.transform.encode.EncoderMVImpute;
import org.apache.sysds.runtime.transform.encode.EncoderOmit;
import org.apache.sysds.runtime.transform.encode.MultiColumnEncoder;
import org.apache.sysds.runtime.transform.meta.TfMetaUtils;
import org.apache.sysds.runtime.util.CollectionUtils;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.stats.TransformStatistics;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONObject;

public class EncoderFactory {
    protected static final Log LOG = LogFactory.getLog((String)EncoderFactory.class.getName());

    public static MultiColumnEncoder createEncoder(String spec, String[] colnames, int clen, FrameBlock meta) {
        return EncoderFactory.createEncoder(spec, colnames, UtilFunctions.nCopies(clen, Types.ValueType.STRING), meta);
    }

    public static MultiColumnEncoder createEncoder(String spec, String[] colnames, int clen, FrameBlock meta, int minCol, int maxCol) {
        return EncoderFactory.createEncoder(spec, colnames, UtilFunctions.nCopies(clen, Types.ValueType.STRING), meta, minCol, maxCol);
    }

    public static MultiColumnEncoder createEncoder(String spec, String[] colnames, Types.ValueType[] schema, int clen, FrameBlock meta) {
        Types.ValueType[] lschema = schema == null ? UtilFunctions.nCopies(clen, Types.ValueType.STRING) : schema;
        return EncoderFactory.createEncoder(spec, colnames, lschema, meta);
    }

    public static MultiColumnEncoder createEncoder(String spec, String[] colnames, Types.ValueType[] schema, FrameBlock meta) {
        return EncoderFactory.createEncoder(spec, colnames, schema, meta, -1, -1);
    }

    public static MultiColumnEncoder createEncoder(String spec, String[] colnames, Types.ValueType[] schema, FrameBlock meta, int minCol, int maxCol) {
        MultiColumnEncoder encoder;
        int clen = schema.length;
        try {
            JSONObject jSpec = new JSONObject(spec);
            ArrayList<ColumnEncoderComposite> lencoders = new ArrayList<ColumnEncoderComposite>();
            HashMap<Integer, List<ColumnEncoder>> colEncoders = new HashMap<Integer, List<ColumnEncoder>>();
            boolean ids = jSpec.containsKey("ids") && jSpec.getBoolean("ids");
            TfMetaUtils.checkValidEncoders(jSpec);
            List<Integer> rcIDs = Arrays.asList(ArrayUtils.toObject((int[])TfMetaUtils.parseJsonIDList(jSpec, colnames, TfUtils.TfMethod.RECODE.toString(), minCol, maxCol)));
            List<Integer> haIDs = Arrays.asList(ArrayUtils.toObject((int[])TfMetaUtils.parseJsonIDList(jSpec, colnames, TfUtils.TfMethod.HASH.toString(), minCol, maxCol)));
            List<Integer> dcIDs = Arrays.asList(ArrayUtils.toObject((int[])TfMetaUtils.parseJsonIDList(jSpec, colnames, TfUtils.TfMethod.DUMMYCODE.toString(), minCol, maxCol)));
            List<Integer> binIDs = TfMetaUtils.parseBinningColIDs(jSpec, colnames, minCol, maxCol);
            rcIDs = CollectionUtils.except(CollectionUtils.unionDistinct(rcIDs, CollectionUtils.except(dcIDs, binIDs)), haIDs);
            List<Integer> ptIDs = CollectionUtils.except(CollectionUtils.except(UtilFunctions.getSeqList(1, clen, 1), CollectionUtils.unionDistinct(rcIDs, haIDs)), binIDs);
            List<Integer> oIDs = Arrays.asList(ArrayUtils.toObject((int[])TfMetaUtils.parseJsonIDList(jSpec, colnames, TfUtils.TfMethod.OMIT.toString(), minCol, maxCol)));
            List<Integer> mvIDs = Arrays.asList(ArrayUtils.toObject((int[])TfMetaUtils.parseJsonObjectIDList(jSpec, colnames, TfUtils.TfMethod.IMPUTE.toString(), minCol, maxCol)));
            List<Integer> udfIDs = TfMetaUtils.parseUDFColIDs(jSpec, colnames, minCol, maxCol);
            if (!rcIDs.isEmpty()) {
                for (Integer n : rcIDs) {
                    EncoderFactory.addEncoderToMap(new ColumnEncoderRecode(n), colEncoders);
                }
            }
            if (!haIDs.isEmpty()) {
                for (Integer n : haIDs) {
                    EncoderFactory.addEncoderToMap(new ColumnEncoderFeatureHash(n, TfMetaUtils.getK(jSpec)), colEncoders);
                }
            }
            if (!ptIDs.isEmpty()) {
                for (Integer n : ptIDs) {
                    EncoderFactory.addEncoderToMap(new ColumnEncoderPassThrough(n), colEncoders);
                }
            }
            if (!binIDs.isEmpty()) {
                for (Integer n : (JSONArray)jSpec.get(TfUtils.TfMethod.BIN.toString())) {
                    ColumnEncoderBin.BinMethod binMethod;
                    int numBins;
                    JSONObject colspec = (JSONObject)((Object)n);
                    int n2 = numBins = colspec.containsKey("numbins") ? colspec.getInt("numbins") : 1;
                    int id = TfMetaUtils.parseJsonObjectID(colspec, colnames, minCol, maxCol, ids);
                    if (id <= 0) continue;
                    String method = colspec.get("method").toString().toUpperCase();
                    if ("EQUI-WIDTH".equals(method)) {
                        binMethod = ColumnEncoderBin.BinMethod.EQUI_WIDTH;
                    } else if ("EQUI-HEIGHT".equals(method)) {
                        binMethod = ColumnEncoderBin.BinMethod.EQUI_HEIGHT;
                    } else {
                        throw new DMLRuntimeException("Unsupported binning method: " + method);
                    }
                    ColumnEncoderBin bin = new ColumnEncoderBin(id, numBins, binMethod);
                    EncoderFactory.addEncoderToMap(bin, colEncoders);
                }
            }
            if (!dcIDs.isEmpty()) {
                for (Integer n : dcIDs) {
                    EncoderFactory.addEncoderToMap(new ColumnEncoderDummycode(n), colEncoders);
                }
            }
            if (!udfIDs.isEmpty()) {
                String name = jSpec.getJSONObject("udf").getString("name");
                for (Integer id : udfIDs) {
                    EncoderFactory.addEncoderToMap(new ColumnEncoderUDF(id, name), colEncoders);
                }
            }
            for (Map.Entry entry : colEncoders.entrySet()) {
                if (DMLScript.STATISTICS) {
                    TransformStatistics.incEncoderCount(((List)entry.getValue()).size());
                }
                lencoders.add(new ColumnEncoderComposite((List)entry.getValue()));
            }
            encoder = new MultiColumnEncoder(lencoders);
            if (!oIDs.isEmpty()) {
                encoder.addReplaceLegacyEncoder(new EncoderOmit(jSpec, colnames, schema.length, minCol, maxCol));
                if (DMLScript.STATISTICS) {
                    TransformStatistics.incEncoderCount(1L);
                }
            }
            if (!mvIDs.isEmpty()) {
                EncoderMVImpute ma = new EncoderMVImpute(jSpec, colnames, schema.length, minCol, maxCol);
                ma.initRecodeIDList(rcIDs);
                encoder.addReplaceLegacyEncoder(ma);
                if (DMLScript.STATISTICS) {
                    TransformStatistics.incEncoderCount(1L);
                }
            }
            if (meta != null) {
                Object[] colnames2 = meta.getColumnNames();
                if (!TfMetaUtils.isIDSpec(jSpec) && colnames != null && colnames2 != null && !ArrayUtils.isEquals((Object)colnames, (Object)colnames2)) {
                    HashMap<String, Integer> hashMap = EncoderFactory.getColumnPositions((String[])colnames2);
                    FrameBlock meta2 = new FrameBlock(meta.getSchema(), (String[])colnames2);
                    for (int i = 0; i < colnames.length; ++i) {
                        if (!hashMap.containsKey(colnames[i])) {
                            throw new DMLRuntimeException("Column name not found in meta data: " + colnames[i] + " (meta: " + Arrays.toString(colnames2) + ")");
                        }
                        int pos = hashMap.get(colnames[i]);
                        meta2.setColumn(i, meta.getColumn(pos));
                        meta2.setColumnMetadata(i, meta.getColumnMetadata(pos));
                    }
                    meta = meta2;
                }
                encoder.initMetaData(meta);
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return encoder;
    }

    private static void addEncoderToMap(ColumnEncoder encoder, HashMap<Integer, List<ColumnEncoder>> map) {
        if (!map.containsKey(encoder._colID)) {
            map.put(encoder._colID, new ArrayList());
        }
        map.get(encoder._colID).add(encoder);
    }

    public static int getEncoderType(ColumnEncoder columnEncoder) {
        if (columnEncoder instanceof ColumnEncoderBin) {
            return ColumnEncoder.EncoderType.Bin.ordinal();
        }
        if (columnEncoder instanceof ColumnEncoderDummycode) {
            return ColumnEncoder.EncoderType.Dummycode.ordinal();
        }
        if (columnEncoder instanceof ColumnEncoderFeatureHash) {
            return ColumnEncoder.EncoderType.FeatureHash.ordinal();
        }
        if (columnEncoder instanceof ColumnEncoderPassThrough) {
            return ColumnEncoder.EncoderType.PassThrough.ordinal();
        }
        if (columnEncoder instanceof ColumnEncoderRecode) {
            return ColumnEncoder.EncoderType.Recode.ordinal();
        }
        throw new DMLRuntimeException("Unsupported encoder type: " + columnEncoder.getClass().getCanonicalName());
    }

    public static ColumnEncoder createInstance(int type) {
        ColumnEncoder.EncoderType etype = ColumnEncoder.EncoderType.values()[type];
        switch (etype) {
            case Bin: {
                return new ColumnEncoderBin();
            }
            case Dummycode: {
                return new ColumnEncoderDummycode();
            }
            case FeatureHash: {
                return new ColumnEncoderFeatureHash();
            }
            case PassThrough: {
                return new ColumnEncoderPassThrough();
            }
            case Recode: {
                return new ColumnEncoderRecode();
            }
        }
        throw new DMLRuntimeException("Unsupported encoder type: " + etype);
    }

    private static HashMap<String, Integer> getColumnPositions(String[] colnames) {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        for (int i = 0; i < colnames.length; ++i) {
            ret.put(colnames[i], i);
        }
        return ret;
    }
}

