/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.dictionary;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IdentityDictionarySlice;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.ValueFunction;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public class IdentityDictionary
extends ADictionary {
    private static final long serialVersionUID = 2535887782150955098L;
    protected final int nRowCol;
    protected SoftReference<MatrixBlockDictionary> cache = null;

    public IdentityDictionary(int nRowCol) {
        if (nRowCol <= 0) {
            throw new DMLCompressionException("Invalid Identity Dictionary");
        }
        this.nRowCol = nRowCol;
    }

    @Override
    public double[] getValues() {
        LOG.warn((Object)"Should not call getValues on Identity Dictionary");
        double[] ret = new double[this.nRowCol * this.nRowCol];
        for (int i = 0; i < this.nRowCol; ++i) {
            ret[i * this.nRowCol + i] = 1.0;
        }
        return ret;
    }

    @Override
    public double getValue(int i) {
        int nCol = this.nRowCol;
        int row = i / nCol;
        if (row > this.nRowCol) {
            return 0.0;
        }
        int col = i % nCol;
        return row == col ? 1.0 : 0.0;
    }

    @Override
    public double getValue(int r, int c, int nCol) {
        return r == c ? 1.0 : 0.0;
    }

    @Override
    public long getInMemorySize() {
        return 16L;
    }

    public static long getInMemorySize(int numberColumns) {
        return 16L;
    }

    @Override
    public double aggregate(double init, Builtin fn) {
        if (fn.getBuiltinCode() == Builtin.BuiltinCode.MAX) {
            return fn.execute(init, 1.0);
        }
        if (fn.getBuiltinCode() == Builtin.BuiltinCode.MIN) {
            return fn.execute(init, 0.0);
        }
        throw new NotImplementedException();
    }

    @Override
    public double aggregateWithReference(double init, Builtin fn, double[] reference, boolean def) {
        return this.getMBDict().aggregateWithReference(init, fn, reference, def);
    }

    @Override
    public double[] aggregateRows(Builtin fn, int nCol) {
        double[] ret = new double[this.nRowCol];
        Arrays.fill(ret, fn.execute(1L, 0L));
        return ret;
    }

    @Override
    public double[] aggregateRowsWithDefault(Builtin fn, double[] defaultTuple) {
        return this.getMBDict().aggregateRowsWithDefault(fn, defaultTuple);
    }

    @Override
    public double[] aggregateRowsWithReference(Builtin fn, double[] reference) {
        return this.getMBDict().aggregateRowsWithReference(fn, reference);
    }

    @Override
    public void aggregateCols(double[] c, Builtin fn, IColIndex colIndexes) {
        for (int i = 0; i < this.nRowCol; ++i) {
            int idx = colIndexes.get(i);
            c[idx] = fn.execute(c[idx], 0.0);
            c[idx] = fn.execute(c[idx], 1.0);
        }
    }

    @Override
    public void aggregateColsWithReference(double[] c, Builtin fn, IColIndex colIndexes, double[] reference, boolean def) {
        this.getMBDict().aggregateColsWithReference(c, fn, colIndexes, reference, def);
    }

    @Override
    public ADictionary applyScalarOp(ScalarOperator op) {
        return this.getMBDict().applyScalarOp(op);
    }

    @Override
    public ADictionary applyScalarOpAndAppend(ScalarOperator op, double v0, int nCol) {
        return this.getMBDict().applyScalarOpAndAppend(op, v0, nCol);
    }

    @Override
    public ADictionary applyUnaryOp(UnaryOperator op) {
        return this.getMBDict().applyUnaryOp(op);
    }

    @Override
    public ADictionary applyUnaryOpAndAppend(UnaryOperator op, double v0, int nCol) {
        return this.getMBDict().applyUnaryOpAndAppend(op, v0, nCol);
    }

    @Override
    public ADictionary applyScalarOpWithReference(ScalarOperator op, double[] reference, double[] newReference) {
        return this.getMBDict().applyScalarOpWithReference(op, reference, newReference);
    }

    @Override
    public ADictionary applyUnaryOpWithReference(UnaryOperator op, double[] reference, double[] newReference) {
        return this.getMBDict().applyUnaryOpWithReference(op, reference, newReference);
    }

    @Override
    public ADictionary binOpLeft(BinaryOperator op, double[] v, IColIndex colIndexes) {
        return this.getMBDict().binOpLeft(op, v, colIndexes);
    }

    @Override
    public ADictionary binOpLeftAndAppend(BinaryOperator op, double[] v, IColIndex colIndexes) {
        return this.getMBDict().binOpLeftAndAppend(op, v, colIndexes);
    }

    @Override
    public ADictionary binOpLeftWithReference(BinaryOperator op, double[] v, IColIndex colIndexes, double[] reference, double[] newReference) {
        return this.getMBDict().binOpLeftWithReference(op, v, colIndexes, reference, newReference);
    }

    @Override
    public ADictionary binOpRight(BinaryOperator op, double[] v, IColIndex colIndexes) {
        return this.getMBDict().binOpRight(op, v, colIndexes);
    }

    @Override
    public ADictionary binOpRightAndAppend(BinaryOperator op, double[] v, IColIndex colIndexes) {
        return this.getMBDict().binOpRightAndAppend(op, v, colIndexes);
    }

    @Override
    public ADictionary binOpRight(BinaryOperator op, double[] v) {
        return this.getMBDict().binOpRight(op, v);
    }

    @Override
    public ADictionary binOpRightWithReference(BinaryOperator op, double[] v, IColIndex colIndexes, double[] reference, double[] newReference) {
        return this.getMBDict().binOpRightWithReference(op, v, colIndexes, reference, newReference);
    }

    @Override
    public ADictionary clone() {
        return new IdentityDictionary(this.nRowCol);
    }

    @Override
    public ADictionary.DictType getDictType() {
        return ADictionary.DictType.Identity;
    }

    @Override
    public int getNumberOfValues(int ncol) {
        return this.nRowCol;
    }

    @Override
    public double[] sumAllRowsToDouble(int nrColumns) {
        double[] ret = new double[this.nRowCol];
        Arrays.fill(ret, 1.0);
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleWithDefault(double[] defaultTuple) {
        double[] ret = new double[this.nRowCol];
        Arrays.fill(ret, 1.0);
        for (int i = 0; i < defaultTuple.length; ++i) {
            int n = i;
            ret[n] = ret[n] + defaultTuple[i];
        }
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleWithReference(double[] reference) {
        double[] ret = new double[this.nRowCol];
        Arrays.fill(ret, 1.0);
        for (int i = 0; i < reference.length; ++i) {
            int n = i;
            ret[n] = ret[n] + reference[i] * (double)this.nRowCol;
        }
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleSq(int nrColumns) {
        double[] ret = new double[this.nRowCol];
        Arrays.fill(ret, 1.0);
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleSqWithDefault(double[] defaultTuple) {
        return this.getMBDict().sumAllRowsToDoubleSqWithDefault(defaultTuple);
    }

    @Override
    public double[] sumAllRowsToDoubleSqWithReference(double[] reference) {
        return this.getMBDict().sumAllRowsToDoubleSqWithReference(reference);
    }

    @Override
    public double[] productAllRowsToDouble(int nCol) {
        return new double[this.nRowCol];
    }

    @Override
    public double[] productAllRowsToDoubleWithDefault(double[] defaultTuple) {
        return new double[this.nRowCol];
    }

    @Override
    public double[] productAllRowsToDoubleWithReference(double[] reference) {
        return this.getMBDict().productAllRowsToDoubleWithReference(reference);
    }

    @Override
    public void colSum(double[] c, int[] counts, IColIndex colIndexes) {
        for (int i = 0; i < colIndexes.size(); ++i) {
            int idx = colIndexes.get(i);
            c[idx] = counts[i];
        }
    }

    @Override
    public void colSumSq(double[] c, int[] counts, IColIndex colIndexes) {
        this.colSum(c, counts, colIndexes);
    }

    @Override
    public void colProduct(double[] res, int[] counts, IColIndex colIndexes) {
        for (int i = 0; i < colIndexes.size(); ++i) {
            res[colIndexes.get((int)i)] = 0.0;
        }
    }

    @Override
    public void colProductWithReference(double[] res, int[] counts, IColIndex colIndexes, double[] reference) {
        this.getMBDict().colProductWithReference(res, counts, colIndexes, reference);
    }

    @Override
    public void colSumSqWithReference(double[] c, int[] counts, IColIndex colIndexes, double[] reference) {
        this.getMBDict().colSumSqWithReference(c, counts, colIndexes, reference);
    }

    @Override
    public double sum(int[] counts, int ncol) {
        double s = 0.0;
        for (int v : counts) {
            s += (double)v;
        }
        return s;
    }

    @Override
    public double sumSq(int[] counts, int ncol) {
        return this.sum(counts, ncol);
    }

    @Override
    public double sumSqWithReference(int[] counts, double[] reference) {
        return this.getMBDict().sumSqWithReference(counts, reference);
    }

    @Override
    public ADictionary sliceOutColumnRange(int idxStart, int idxEnd, int previousNumberOfColumns) {
        if (idxStart == 0 && idxEnd == this.nRowCol) {
            return new IdentityDictionary(this.nRowCol);
        }
        return new IdentityDictionarySlice(this.nRowCol, idxStart, idxEnd);
    }

    @Override
    public boolean containsValue(double pattern) {
        return pattern == 0.0 || pattern == 1.0;
    }

    @Override
    public boolean containsValueWithReference(double pattern, double[] reference) {
        return this.getMBDict().containsValueWithReference(pattern, reference);
    }

    @Override
    public long getNumberNonZeros(int[] counts, int nCol) {
        return (long)this.sum(counts, nCol);
    }

    @Override
    public long getNumberNonZerosWithReference(int[] counts, double[] reference, int nRows) {
        return this.getMBDict().getNumberNonZerosWithReference(counts, reference, nRows);
    }

    @Override
    public void addToEntry(double[] v, int fr, int to, int nCol) {
        this.getMBDict().addToEntry(v, fr, to, nCol);
    }

    @Override
    public void addToEntry(double[] v, int fr, int to, int nCol, int rep) {
        this.getMBDict().addToEntry(v, fr, to, nCol, rep);
    }

    @Override
    public void addToEntryVectorized(double[] v, int f1, int f2, int f3, int f4, int f5, int f6, int f7, int f8, int t1, int t2, int t3, int t4, int t5, int t6, int t7, int t8, int nCol) {
        this.getMBDict().addToEntryVectorized(v, f1, f2, f3, f4, f5, f6, f7, f8, t1, t2, t3, t4, t5, t6, t7, t8, nCol);
    }

    @Override
    public ADictionary subtractTuple(double[] tuple) {
        return this.getMBDict().subtractTuple(tuple);
    }

    public MatrixBlockDictionary getMBDict() {
        throw new DMLRuntimeException("Do not make MB Dict");
    }

    @Override
    public MatrixBlockDictionary getMBDict(int nCol) {
        MatrixBlockDictionary r;
        if (this.cache != null && (r = this.cache.get()) != null) {
            return r;
        }
        MatrixBlockDictionary ret = this.createMBDict();
        this.cache = new SoftReference<MatrixBlockDictionary>(ret);
        return ret;
    }

    private MatrixBlockDictionary createMBDict() {
        MatrixBlock identity = new MatrixBlock(this.nRowCol, this.nRowCol, true);
        for (int i = 0; i < this.nRowCol; ++i) {
            identity.quickSetValue(i, i, 1.0);
        }
        return new MatrixBlockDictionary(identity);
    }

    @Override
    public String getString(int colIndexes) {
        return "IdentityMatrix of size: " + this.nRowCol;
    }

    public String toString() {
        return "IdentityMatrix of size: " + this.nRowCol;
    }

    @Override
    public ADictionary scaleTuples(int[] scaling, int nCol) {
        return this.getMBDict().scaleTuples(scaling, nCol);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(DictionaryFactory.Type.IDENTITY.ordinal());
        out.writeInt(this.nRowCol);
    }

    public static IdentityDictionary read(DataInput in) throws IOException {
        return new IdentityDictionary(in.readInt());
    }

    @Override
    public long getExactSizeOnDisk() {
        return 5L;
    }

    @Override
    public ADictionary preaggValuesFromDense(int numVals, IColIndex colIndexes, IColIndex aggregateColumns, double[] b, int cut) {
        return this.getMBDict().preaggValuesFromDense(numVals, colIndexes, aggregateColumns, b, cut);
    }

    @Override
    public ADictionary replace(double pattern, double replace, int nCol) {
        if (this.containsValue(pattern)) {
            return this.getMBDict().replace(pattern, replace, nCol);
        }
        return this;
    }

    @Override
    public ADictionary replaceWithReference(double pattern, double replace, double[] reference) {
        if (this.containsValueWithReference(pattern, reference)) {
            return this.getMBDict().replaceWithReference(pattern, replace, reference);
        }
        return this;
    }

    @Override
    public void product(double[] ret, int[] counts, int nCol) {
        this.getMBDict().product(ret, counts, nCol);
    }

    @Override
    public void productWithDefault(double[] ret, int[] counts, double[] def, int defCount) {
        this.getMBDict().productWithDefault(ret, counts, def, defCount);
    }

    @Override
    public void productWithReference(double[] ret, int[] counts, double[] reference, int refCount) {
        this.getMBDict().productWithReference(ret, counts, reference, refCount);
    }

    @Override
    public CM_COV_Object centralMoment(CM_COV_Object ret, ValueFunction fn, int[] counts, int nRows) {
        return this.getMBDict().centralMoment(ret, fn, counts, nRows);
    }

    @Override
    public CM_COV_Object centralMomentWithDefault(CM_COV_Object ret, ValueFunction fn, int[] counts, double def, int nRows) {
        return this.getMBDict().centralMomentWithDefault(ret, fn, counts, def, nRows);
    }

    @Override
    public CM_COV_Object centralMomentWithReference(CM_COV_Object ret, ValueFunction fn, int[] counts, double reference, int nRows) {
        return this.getMBDict().centralMomentWithReference(ret, fn, counts, reference, nRows);
    }

    @Override
    public ADictionary rexpandCols(int max, boolean ignore, boolean cast, int nCol) {
        return this.getMBDict().rexpandCols(max, ignore, cast, nCol);
    }

    @Override
    public ADictionary rexpandColsWithReference(int max, boolean ignore, boolean cast, int reference) {
        return this.getMBDict().rexpandColsWithReference(max, ignore, cast, reference);
    }

    @Override
    public double getSparsity() {
        return 1.0 / (double)this.nRowCol;
    }

    @Override
    public void multiplyScalar(double v, double[] ret, int off, int dictIdx, IColIndex cols) {
        this.getMBDict().multiplyScalar(v, ret, off, dictIdx, cols);
    }

    @Override
    protected void TSMMWithScaling(int[] counts, IColIndex rows, IColIndex cols, MatrixBlock ret) {
        this.getMBDict().TSMMWithScaling(counts, rows, cols, ret);
    }

    @Override
    protected void MMDict(ADictionary right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        this.getMBDict().MMDict(right, rowsLeft, colsRight, result);
    }

    @Override
    protected void MMDictDense(double[] left, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        this.getMBDict().MMDictDense(left, rowsLeft, colsRight, result);
    }

    @Override
    protected void MMDictSparse(SparseBlock left, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        this.getMBDict().MMDictSparse(left, rowsLeft, colsRight, result);
    }

    @Override
    protected void TSMMToUpperTriangle(ADictionary right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        this.getMBDict().TSMMToUpperTriangle(right, rowsLeft, colsRight, result);
    }

    @Override
    protected void TSMMToUpperTriangleDense(double[] left, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        this.getMBDict().TSMMToUpperTriangleDense(left, rowsLeft, colsRight, result);
    }

    @Override
    protected void TSMMToUpperTriangleSparse(SparseBlock left, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        this.getMBDict().TSMMToUpperTriangleSparse(left, rowsLeft, colsRight, result);
    }

    @Override
    protected void TSMMToUpperTriangleScaling(ADictionary right, IColIndex rowsLeft, IColIndex colsRight, int[] scale, MatrixBlock result) {
        this.getMBDict().TSMMToUpperTriangleScaling(right, rowsLeft, colsRight, scale, result);
    }

    @Override
    protected void TSMMToUpperTriangleDenseScaling(double[] left, IColIndex rowsLeft, IColIndex colsRight, int[] scale, MatrixBlock result) {
        this.getMBDict().TSMMToUpperTriangleDenseScaling(left, rowsLeft, colsRight, scale, result);
    }

    @Override
    protected void TSMMToUpperTriangleSparseScaling(SparseBlock left, IColIndex rowsLeft, IColIndex colsRight, int[] scale, MatrixBlock result) {
        this.getMBDict().TSMMToUpperTriangleSparseScaling(left, rowsLeft, colsRight, scale, result);
    }

    @Override
    public boolean equals(ADictionary o) {
        if (o instanceof IdentityDictionary) {
            return ((IdentityDictionary)o).nRowCol == this.nRowCol;
        }
        MatrixBlock mb = this.getMBDict().getMatrixBlock();
        if (o instanceof MatrixBlockDictionary) {
            return mb.equals(((MatrixBlockDictionary)o).getMatrixBlock());
        }
        if (o instanceof Dictionary) {
            if (mb.isInSparseFormat()) {
                return mb.getSparseBlock().equals(((Dictionary)o)._values, this.nRowCol);
            }
            double[] dv = mb.getDenseBlockValues();
            return Arrays.equals(dv, ((Dictionary)o)._values);
        }
        return false;
    }
}

