/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.caching;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheStatistics;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.LazyWriteBuffer;
import org.apache.sysds.runtime.controlprogram.caching.UnifiedMemoryManager;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.data.TensorBlock;
import org.apache.sysds.runtime.instructions.spark.data.RDDObject;
import org.apache.sysds.runtime.io.FileFormatProperties;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageRecomputeUtils;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MetaData;
import org.apache.sysds.runtime.meta.MetaDataFormat;
import org.apache.sysds.runtime.meta.TensorCharacteristics;
import org.apache.sysds.runtime.util.DataConverter;

public class TensorObject
extends CacheableData<TensorBlock> {
    private static final long serialVersionUID = -2843358400200380775L;

    protected TensorObject() {
        super(Types.DataType.TENSOR, Types.ValueType.STRING);
    }

    public TensorObject(String fname) {
        this();
        this.setFileName(fname);
    }

    public TensorObject(Types.ValueType vt, String fname) {
        super(Types.DataType.TENSOR, vt);
        this.setFileName(fname);
    }

    public TensorObject(String fname, MetaData meta) {
        this();
        this.setFileName(fname);
        this.setMetaData(meta);
    }

    public TensorObject(TensorObject fo) {
        super(fo);
    }

    @Override
    public void refreshMetaData() {
        if (this._data == null || this._metaData == null) {
            throw new DMLRuntimeException("Cannot refresh meta data because there is no data or meta data. ");
        }
        DataCharacteristics tc = this._metaData.getDataCharacteristics();
        long[] dims = this._metaData.getDataCharacteristics().getDims();
        tc.setDims(dims);
        tc.setNonZeros(((TensorBlock)this._data).getNonZeros());
    }

    @Override
    public long getNumRows() {
        DataCharacteristics dc = this.getDataCharacteristics();
        return dc.getDim(0);
    }

    @Override
    public long getNumColumns() {
        DataCharacteristics dc = this.getDataCharacteristics();
        return dc.getDim(1);
    }

    public long getNnz() {
        return this.getDataCharacteristics().getNonZeros();
    }

    @Override
    protected TensorBlock readBlobFromCache(String fname) throws IOException {
        TensorBlock tb = null;
        tb = OptimizerUtils.isUMMEnabled() ? (TensorBlock)UnifiedMemoryManager.readBlock(fname, false) : (TensorBlock)LazyWriteBuffer.readBlock(fname, false);
        return tb;
    }

    @Override
    protected TensorBlock readBlobFromHDFS(String fname, long[] dims) throws IOException {
        MetaDataFormat iimd = (MetaDataFormat)this._metaData;
        DataCharacteristics dc = iimd.getDataCharacteristics();
        long begin = 0L;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Reading tensor from HDFS...  " + this.hashCode() + "  Path: " + fname + ", dimensions: " + Arrays.toString(dims)));
            begin = System.currentTimeMillis();
        }
        int blen = dc.getBlocksize();
        TensorBlock newData = DataConverter.readTensorFromHDFS(fname, iimd.getFileFormat(), dims, blen, this.getSchema());
        this.setHDFSFileExists(true);
        if (newData == null) {
            throw new IOException("Unable to load tensor from file: " + fname);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Reading Completed: " + (System.currentTimeMillis() - begin) + " msec."));
        }
        return newData;
    }

    @Override
    protected TensorBlock readBlobFromRDD(RDDObject rdd, MutableBoolean status) {
        status.setValue(false);
        TensorCharacteristics tc = (TensorCharacteristics)this._metaData.getDataCharacteristics();
        return SparkExecutionContext.toTensorBlock(rdd.getRDD(), tc);
    }

    @Override
    protected TensorBlock readBlobFromFederated(FederationMap fedMap, long[] dims) throws IOException {
        throw new DMLRuntimeException("Unsupported federated tensors");
    }

    @Override
    protected void writeBlobToHDFS(String fname, String ofmt, int rep, FileFormatProperties fprop) throws IOException, DMLRuntimeException {
        long begin = 0L;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(" Writing tensor to HDFS...  " + this.hashCode() + "  Path: " + fname + ", Format: " + (ofmt != null ? ofmt : "inferred from metadata")));
            begin = System.currentTimeMillis();
        }
        MetaDataFormat iimd = (MetaDataFormat)this._metaData;
        if (this._data != null) {
            DataCharacteristics dc = iimd.getDataCharacteristics();
            Types.FileFormat fmt = ofmt != null ? Types.FileFormat.safeValueOf(ofmt) : iimd.getFileFormat();
            DataConverter.writeTensorToHDFS((TensorBlock)this._data, fname, fmt, dc);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Writing tensor to HDFS (" + fname + ") - COMPLETED... " + (System.currentTimeMillis() - begin) + " msec."));
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Writing tensor to HDFS (" + fname + ") - NOTHING TO WRITE (_data == null)."));
        }
        if (DMLScript.STATISTICS) {
            CacheStatistics.incrementHDFSWrites();
        }
    }

    @Override
    protected Types.ValueType[] getSchema() {
        return ((TensorBlock)this._data).getSchema();
    }

    @Override
    protected void writeBlobFromRDDtoHDFS(RDDObject rdd, String fname, String ofmt) throws DMLRuntimeException {
    }

    @Override
    protected TensorBlock reconstructByLineage(LineageItem li) throws IOException {
        return (TensorBlock)((TensorObject)LineageRecomputeUtils.parseNComputeLineageTrace(li.getData(), null)).acquireReadAndRelease();
    }
}

