/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.conf.CompilerConfig;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.MatrixWriter;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.util.HDFSTool;

public class WriterBinaryBlock
extends MatrixWriter {
    protected int _replication = -1;
    protected static int jobUse = 0;
    protected static JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());

    public WriterBinaryBlock(int replication) {
        this._replication = replication;
        if (++jobUse > 15) {
            job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
            jobUse = 0;
        }
    }

    @Override
    public final void writeMatrixToHDFS(MatrixBlock src, String fname, long rlen, long clen, int blen, long nnz, boolean diag) throws IOException, DMLRuntimeException {
        Path path = new Path(fname);
        HDFSTool.deleteFileIfExistOnHDFS(path, job);
        HDFSTool.addBinaryBlockSerializationFramework((Configuration)job);
        if (src instanceof CompressedMatrixBlock) {
            if (ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_BINARYFORMATS)) {
                LOG.debug((Object)"Multi threaded decompression");
                src = CompressedMatrixBlock.getUncompressed(src, "binary write", OptimizerUtils.getParallelBinaryWriteParallelism());
            } else {
                LOG.warn((Object)"Single threaded decompression");
                src = CompressedMatrixBlock.getUncompressed(src, "binary write");
            }
        }
        if (diag) {
            this.writeDiagBinaryBlockMatrixToHDFS(path, job, src, rlen, clen, blen);
        } else {
            this.writeBinaryBlockMatrixToHDFS(path, job, src, rlen, clen, blen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void writeEmptyMatrixToHDFS(String fname, long rlen, long clen, int blen) throws IOException, DMLRuntimeException {
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        SequenceFile.Writer writer = IOUtilFunctions.getSeqWriter(path, (Configuration)job, this._replication);
        try {
            MatrixIndexes index = new MatrixIndexes(1L, 1L);
            MatrixBlock block = new MatrixBlock((int)Math.max(Math.min(rlen, (long)blen), 1L), (int)Math.max(Math.min(clen, (long)blen), 1L), true);
            writer.append((Writable)index, (Writable)block);
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)writer);
        }
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
    }

    protected void writeBinaryBlockMatrixToHDFS(Path path, JobConf job, MatrixBlock src, long rlen, long clen, int blen) throws IOException, DMLRuntimeException {
        this.writeBinaryBlockMatrixToSequenceFile(path, job, src, blen, 0, (int)rlen);
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(job, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeBinaryBlockMatrixToSequenceFile(Path path, JobConf job, MatrixBlock src, int blen, int rl, int ru) throws IOException {
        boolean sparse = src.isInSparseFormat();
        int rlen = src.getNumRows();
        int clen = src.getNumColumns();
        SequenceFile.Writer writer = IOUtilFunctions.getSeqWriter(path, (Configuration)job, this._replication);
        try {
            MatrixIndexes indexes = new MatrixIndexes();
            if (rlen <= blen && clen <= blen && rl == 0) {
                indexes.setIndexes(1L, 1L);
                writer.append((Writable)indexes, (Writable)src);
            } else {
                MatrixBlock[] blocks = WriterBinaryBlock.createMatrixBlocksForReuse(rlen, clen, blen, sparse, src.getNonZeros());
                for (int blockRow = rl / blen; blockRow < (int)Math.ceil((double)ru / (double)blen); ++blockRow) {
                    for (int blockCol = 0; blockCol < (int)Math.ceil((double)clen / (double)blen); ++blockCol) {
                        int maxRow = blockRow * blen + blen < rlen ? blen : rlen - blockRow * blen;
                        int maxCol = blockCol * blen + blen < clen ? blen : clen - blockCol * blen;
                        int row_offset = blockRow * blen;
                        int col_offset = blockCol * blen;
                        MatrixBlock block = WriterBinaryBlock.getMatrixBlockForReuse(blocks, maxRow, maxCol, blen);
                        src.slice(row_offset, row_offset + maxRow - 1, col_offset, col_offset + maxCol - 1, block);
                        indexes.setIndexes(blockRow + 1, blockCol + 1);
                        writer.append((Writable)indexes, (Writable)block);
                        block.reset();
                    }
                }
            }
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeDiagBinaryBlockMatrixToHDFS(Path path, JobConf job, MatrixBlock src, long rlen, long clen, int blen) throws IOException {
        boolean sparse = src.isInSparseFormat();
        int nRow = src.getNumRows();
        int nCol = src.getNumColumns();
        SequenceFile.Writer writer = IOUtilFunctions.getSeqWriter(path, (Configuration)job, this._replication);
        try {
            if ((long)nRow > rlen || (long)nCol > clen) {
                throw new IOException("Matrix block [1:" + nRow + ",1:" + nCol + "] out of overall matrix range [1:" + rlen + ",1:" + clen + "].");
            }
            MatrixIndexes indexes = new MatrixIndexes();
            if (rlen <= (long)blen && clen <= (long)blen) {
                indexes.setIndexes(1L, 1L);
                writer.append((Writable)indexes, (Writable)src);
            } else {
                MatrixBlock[] blocks = WriterBinaryBlock.createMatrixBlocksForReuse(rlen, clen, blen, sparse, src.getNonZeros());
                MatrixBlock emptyBlock = new MatrixBlock();
                for (int blockRow = 0; blockRow < (int)Math.ceil((double)nRow / (double)blen); ++blockRow) {
                    for (int blockCol = 0; blockCol < (int)Math.ceil((double)nCol / (double)blen); ++blockCol) {
                        int maxRow = blockRow * blen + blen < nRow ? blen : nRow - blockRow * blen;
                        int maxCol = blockCol * blen + blen < nCol ? blen : nCol - blockCol * blen;
                        MatrixBlock block = null;
                        if (blockRow == blockCol) {
                            int row_offset = blockRow * blen;
                            int col_offset = blockCol * blen;
                            block = WriterBinaryBlock.getMatrixBlockForReuse(blocks, maxRow, maxCol, blen);
                            src.slice(row_offset, row_offset + maxRow - 1, col_offset, col_offset + maxCol - 1, block);
                        } else {
                            block = emptyBlock;
                            block.reset(maxRow, maxCol);
                        }
                        indexes.setIndexes(blockRow + 1, blockCol + 1);
                        writer.append((Writable)indexes, (Writable)block);
                        if (blockRow == blockCol) continue;
                        block.reset();
                    }
                }
            }
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)writer);
        }
    }
}

