/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io.hdf5;

import java.nio.ByteBuffer;
import org.apache.sysds.runtime.io.hdf5.H5BufferBuilder;
import org.apache.sysds.runtime.io.hdf5.H5RootObject;
import org.apache.sysds.runtime.io.hdf5.Utils;

public class H5SymbolTableEntry {
    private final long address;
    private final int linkNameOffset;
    private final long objectHeaderAddress;
    private final int cacheType;
    private final long bTreeAddress;
    private final long nameHeapAddress;

    public H5SymbolTableEntry(H5RootObject rootObject) {
        this.address = rootObject.getSuperblock().rootGroupSymbolTableAddress;
        this.linkNameOffset = 0;
        this.objectHeaderAddress = 96L;
        this.cacheType = 1;
        this.bTreeAddress = 136L;
        this.nameHeapAddress = 680L;
    }

    public H5SymbolTableEntry(int linkNameOffset, long objectHeaderAddress, int cacheType, long bTreeAddress, long nameHeapAddress) {
        this.address = 0L;
        this.linkNameOffset = linkNameOffset;
        this.objectHeaderAddress = objectHeaderAddress;
        this.cacheType = cacheType;
        this.bTreeAddress = bTreeAddress;
        this.nameHeapAddress = nameHeapAddress;
    }

    public void toBuffer(H5BufferBuilder bb) {
        bb.writeLong(this.linkNameOffset);
        bb.writeLong(this.objectHeaderAddress);
        bb.writeInt(this.cacheType);
        bb.writeInt(0);
        if (this.cacheType == 1) {
            bb.writeLong(this.bTreeAddress);
            bb.writeLong(this.nameHeapAddress);
        }
    }

    public H5SymbolTableEntry(H5RootObject rootObject, long address) {
        this.address = address;
        int size = rootObject.getSuperblock().sizeOfOffsets * 2 + 4 + 4 + 16;
        ByteBuffer bb = rootObject.readBufferFromAddress(address, size);
        this.linkNameOffset = Utils.readBytesAsUnsignedInt(bb, rootObject.getSuperblock().sizeOfOffsets);
        this.objectHeaderAddress = Utils.readBytesAsUnsignedLong(bb, rootObject.getSuperblock().sizeOfOffsets);
        this.cacheType = Utils.readBytesAsUnsignedInt(bb, 4);
        bb.get(new byte[4]);
        this.bTreeAddress = Utils.readBytesAsUnsignedLong(bb, rootObject.getSuperblock().sizeOfOffsets);
        this.nameHeapAddress = Utils.readBytesAsUnsignedLong(bb, rootObject.getSuperblock().sizeOfOffsets);
    }

    public long getAddress() {
        return this.address;
    }

    public int getLinkNameOffset() {
        return this.linkNameOffset;
    }

    public long getObjectHeaderAddress() {
        return this.objectHeaderAddress;
    }

    public int getCacheType() {
        return this.cacheType;
    }

    public long getbTreeAddress() {
        return this.bTreeAddress;
    }

    public long getNameHeapAddress() {
        return this.nameHeapAddress;
    }
}

