/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.beaneditor;

import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.ioc.internal.util.InternalCommonsUtils;

public final class BeanModelUtils {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static void modify(BeanModel model, String addPropertyNames, String includePropertyNames, String excludePropertyNames, String reorderPropertyNames) {
        if (addPropertyNames != null) {
            BeanModelUtils.add(model, addPropertyNames);
        }
        if (includePropertyNames != null) {
            BeanModelUtils.include(model, BeanModelUtils.join(includePropertyNames, addPropertyNames));
        }
        if (excludePropertyNames != null) {
            BeanModelUtils.exclude(model, excludePropertyNames);
        }
        if (reorderPropertyNames != null) {
            BeanModelUtils.reorder(model, reorderPropertyNames);
        }
    }

    private static final String join(String firstList, String optionalSecondList) {
        if (InternalCommonsUtils.isBlank((String)optionalSecondList)) {
            return firstList;
        }
        return firstList + "," + optionalSecondList;
    }

    public static void add(BeanModel model, String propertyNames) {
        for (String name : BeanModelUtils.split(propertyNames)) {
            model.addEmpty(name);
        }
    }

    public static void exclude(BeanModel model, String propertyNames) {
        model.exclude(BeanModelUtils.split(propertyNames));
    }

    public static void include(BeanModel model, String propertyNames) {
        model.include(BeanModelUtils.split(propertyNames));
    }

    public static void reorder(BeanModel model, String propertyNames) {
        model.reorder(BeanModelUtils.split(propertyNames));
    }

    static String[] split(String propertyNames) {
        String trimmed = propertyNames.trim();
        if (trimmed.length() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return trimmed.split("\\s*,\\s*");
    }
}

