/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.pageload;

import java.util.List;
import org.apache.tapestry5.internal.pageload.ComponentAssembler;
import org.apache.tapestry5.internal.pageload.CompositeRenderCommand;
import org.apache.tapestry5.internal.pageload.PageAssembly;
import org.apache.tapestry5.internal.pageload.PageAssemblyAction;
import org.apache.tapestry5.internal.pageload.TokenStream;
import org.apache.tapestry5.internal.parser.TemplateToken;
import org.apache.tapestry5.internal.parser.TokenType;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.runtime.RenderCommand;

class AssemblerContext
implements TokenStream {
    final ComponentAssembler assembler;
    final TokenStream stream;
    final boolean strictMixinParameters;
    private final List<RenderCommand> composable = CollectionFactory.newList();

    AssemblerContext(ComponentAssembler assembler, TokenStream stream, boolean strictMixinParameters) {
        this.assembler = assembler;
        this.stream = stream;
        this.strictMixinParameters = strictMixinParameters;
    }

    @Override
    public boolean more() {
        return this.stream.more();
    }

    @Override
    public TemplateToken next() {
        return this.stream.next();
    }

    @Override
    public <T extends TemplateToken> T next(Class<T> type) {
        return this.stream.next(type);
    }

    @Override
    public TokenType peekType() {
        return this.stream.peekType();
    }

    void addComposable(RenderCommand command) {
        this.composable.add(command);
    }

    void flushComposable() {
        switch (this.composable.size()) {
            case 0: {
                return;
            }
            case 1: {
                this.addRenderCommand(this.composable.get(0));
                break;
            }
            default: {
                this.addRenderCommand(new CompositeRenderCommand(this.composable.toArray(new RenderCommand[this.composable.size()])));
            }
        }
        this.composable.clear();
    }

    void add(PageAssemblyAction action) {
        this.flushComposable();
        this.assembler.add(action);
    }

    private void addRenderCommand(final RenderCommand command) {
        this.assembler.add(new PageAssemblyAction(){

            @Override
            public void execute(PageAssembly pageAssembly) {
                pageAssembly.addRenderCommand(command);
            }
        });
    }
}

