/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.hibernate;

import java.util.List;
import org.apache.tapestry5.hibernate.HibernateConfigurer;
import org.apache.tapestry5.hibernate.HibernateSessionSource;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.RegistryShutdownHub;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.slf4j.Logger;

public class HibernateSessionSourceImpl
implements HibernateSessionSource {
    private final SessionFactory sessionFactory;
    private final Configuration configuration;

    public HibernateSessionSourceImpl(Logger logger, List<HibernateConfigurer> hibernateConfigurers) {
        long startTime = System.currentTimeMillis();
        this.configuration = new Configuration();
        for (HibernateConfigurer configurer : hibernateConfigurers) {
            configurer.configure(this.configuration);
        }
        long configurationComplete = System.currentTimeMillis();
        this.sessionFactory = this.configuration.buildSessionFactory();
        long factoryCreated = System.currentTimeMillis();
        logger.info(String.format("Hibernate startup: %,d ms to configure, %,d ms overall.", configurationComplete - startTime, factoryCreated - startTime));
        logger.info(String.format("Configured Hibernate entities: %s", InternalUtils.joinSorted(this.sessionFactory.getAllClassMetadata().keySet())));
    }

    @PostInjection
    public void listenForShutdown(RegistryShutdownHub hub) {
        hub.addRegistryShutdownListener(new Runnable(){

            @Override
            public void run() {
                HibernateSessionSourceImpl.this.sessionFactory.close();
            }
        });
    }

    @Override
    public Session create() {
        return this.sessionFactory.openSession();
    }

    @Override
    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }
}

