/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.List;
import org.apache.tapestry5.FieldValidator;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValidationException;

public final class CompositeFieldValidator
implements FieldValidator {
    private final FieldValidator[] validators;

    public CompositeFieldValidator(List<FieldValidator> validators) {
        this.validators = validators.toArray(new FieldValidator[validators.size()]);
    }

    public void validate(Object value) throws ValidationException {
        for (FieldValidator fv : this.validators) {
            fv.validate(value);
        }
    }

    @Override
    public void render(MarkupWriter writer) {
        for (FieldValidator fv : this.validators) {
            fv.render(writer);
        }
    }

    @Override
    public boolean isRequired() {
        for (FieldValidator fv : this.validators) {
            if (!fv.isRequired()) continue;
            return true;
        }
        return false;
    }
}

