/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.assets;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.http.services.Response;
import org.apache.tapestry5.internal.services.ResourceStreamer;
import org.apache.tapestry5.internal.services.assets.JavaScriptStackAssembler;
import org.apache.tapestry5.ioc.IOOperation;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.services.LocalizationSetter;
import org.apache.tapestry5.services.assets.AssetRequestHandler;
import org.apache.tapestry5.services.assets.StreamableResource;
import org.apache.tapestry5.services.javascript.JavaScriptStack;
import org.apache.tapestry5.services.javascript.JavaScriptStackSource;
import org.slf4j.Logger;

public class StackAssetRequestHandler
implements AssetRequestHandler {
    private final Logger logger;
    private final LocalizationSetter localizationSetter;
    private final ResourceStreamer resourceStreamer;
    private final Pattern pathPattern = Pattern.compile("^(.+)/(.+)/(.+)\\.js$");
    private final OperationTracker tracker;
    private final JavaScriptStackAssembler javaScriptStackAssembler;
    private final JavaScriptStackSource stackSource;

    public StackAssetRequestHandler(Logger logger, LocalizationSetter localizationSetter, ResourceStreamer resourceStreamer, OperationTracker tracker, JavaScriptStackAssembler javaScriptStackAssembler, JavaScriptStackSource stackSource) {
        this.logger = logger;
        this.localizationSetter = localizationSetter;
        this.resourceStreamer = resourceStreamer;
        this.tracker = tracker;
        this.javaScriptStackAssembler = javaScriptStackAssembler;
        this.stackSource = stackSource;
    }

    @Override
    public boolean handleAssetRequest(Request request, Response response, final String extraPath) throws IOException {
        return (Boolean)this.tracker.perform(String.format("Streaming JavaScript asset stack %s", extraPath), (IOOperation)new IOOperation<Boolean>(){

            public Boolean perform() throws IOException {
                return StackAssetRequestHandler.this.streamStackResource(extraPath);
            }
        });
    }

    private boolean streamStackResource(String extraPath) throws IOException {
        JavaScriptStack stack;
        Matcher matcher = this.pathPattern.matcher(extraPath);
        if (!matcher.matches()) {
            this.logger.warn("Unable to parse '{}' as an asset stack path", (Object)extraPath);
            return false;
        }
        String checksum = matcher.group(1);
        String localeName = matcher.group(2);
        final String stackName = matcher.group(3);
        final boolean compressed = checksum.startsWith("z");
        if (compressed) {
            checksum = checksum.substring(1);
        }
        if ((stack = this.stackSource.findStack(stackName)) == null) {
            this.logger.warn("JavaScript stack '{}' not found.", (Object)stackName);
            return false;
        }
        this.localizationSetter.setNonPersistentLocaleFromLocaleName(localeName);
        StreamableResource resource = (StreamableResource)this.tracker.perform(String.format("Assembling JavaScript asset stack '%s' (%s)", stackName, localeName), (IOOperation)new IOOperation<StreamableResource>(){

            public StreamableResource perform() throws IOException {
                return StackAssetRequestHandler.this.javaScriptStackAssembler.assembleJavaScriptResourceForStack(stackName, compressed, stack.getJavaScriptAggregationStrategy());
            }
        });
        if (resource == null) {
            return false;
        }
        return this.resourceStreamer.streamResource(resource, checksum, ResourceStreamer.DEFAULT_OPTIONS);
    }
}

