/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import org.apache.tapestry5.http.ContentType;
import org.apache.tapestry5.internal.services.PageContentTypeAnalyzer;
import org.apache.tapestry5.internal.services.PageResponseRenderer;
import org.apache.tapestry5.internal.services.RequestPageCache;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.services.ResponseRenderer;

public class ResponseRendererImpl
implements ResponseRenderer {
    private final RequestPageCache pageCache;
    private final PageContentTypeAnalyzer pageContentAnalyzer;
    private final PageResponseRenderer renderer;

    public ResponseRendererImpl(RequestPageCache pageCache, PageContentTypeAnalyzer pageContentAnalyzer, PageResponseRenderer renderer) {
        this.pageCache = pageCache;
        this.pageContentAnalyzer = pageContentAnalyzer;
        this.renderer = renderer;
    }

    @Override
    public ContentType findContentType(Object component) {
        Component c = (Component)component;
        String pageName = c.getComponentResources().getPageName();
        Page page = this.pageCache.get(pageName);
        return this.pageContentAnalyzer.findContentType(page);
    }

    @Override
    public void renderPageMarkupResponse(String pageName) throws IOException {
        Page page = this.pageCache.get(pageName);
        this.renderer.renderPageResponse(page);
    }
}

