/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import java.util.Collection;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.Binding;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.FieldValidator;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.Renderable;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.corelib.base.AbstractField;
import org.apache.tapestry5.internal.util.SelectModelRenderer;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.services.compatibility.DeprecationWarning;

@Import(stylesheet={"Palette.css"})
public class Palette
extends AbstractField {
    @Parameter
    private Asset deselect;
    @Parameter(required=true, allowNull=false)
    private ValueEncoder<Object> encoder;
    @Parameter(required=true, allowNull=false)
    private SelectModel model;
    @Property(write=false)
    @Parameter(required=true, allowNull=false, value="message:core-palette-available-label", defaultPrefix="literal")
    private Block availableLabel;
    @Property(write=false)
    @Parameter(required=true, allowNull=false, value="message:core-palette-selected-label", defaultPrefix="literal")
    private Block selectedLabel;
    @Parameter
    private Asset moveDown;
    @Parameter
    private Asset moveUp;
    @Parameter
    private Asset select;
    @Parameter(required=true, autoconnect=true, allowNull=false)
    private Collection<Object> selected;
    @Parameter(value="false")
    @Property(write=false)
    private boolean reorder;
    @Property(write=false)
    @Parameter(value="symbol:tapestry.components.palette_rows_size")
    private int size;
    @Parameter(defaultPrefix="validate")
    private FieldValidator<Object> validate;
    @Inject
    @Symbol(value="tapestry.compact-json")
    private boolean compactJSON;
    @Inject
    private DeprecationWarning deprecationWarning;
    @Property(write=false)
    private final Renderable mainRenderer = new Renderable(){

        @Override
        public void render(MarkupWriter writer) {
            SelectModelRenderer visitor = new SelectModelRenderer(writer, Palette.this.encoder, false);
            Palette.this.model.visit(visitor);
        }
    };

    void pageLoaded() {
        this.deprecationWarning.ignoredComponentParameters(this.resources, "select", "moveUp", "moveDown", "deselect");
    }

    public String getInitialJSON() {
        JSONArray array = new JSONArray();
        for (Object o : this.selected) {
            String value = this.encoder.toClient(o);
            array.put((Object)value);
        }
        return array.toString(this.compactJSON);
    }

    @Override
    protected void processSubmission(String controlName) {
        String parameterValue = this.request.getParameter(controlName);
        JSONArray values = new JSONArray(parameterValue);
        Collection<Object> selected = this.selected;
        selected.clear();
        ValueEncoder<Object> encoder = this.encoder;
        int count = values.length();
        for (int i = 0; i < count; ++i) {
            String value = values.getString(i);
            Object objectValue = encoder.toValue(value);
            selected.add(objectValue);
        }
        this.putPropertyNameIntoBeanValidationContext("selected");
        try {
            this.fieldValidationSupport.validate(selected, this.resources, this.validate);
            this.selected = selected;
        }
        catch (ValidationException e) {
            this.validationTracker.recordError(this, e.getMessage());
        }
        this.removePropertyNameFromBeanValidationContext();
    }

    void beginRender() {
        String clientId = this.getClientId();
        this.javaScriptSupport.require("t5/core/palette").with(clientId);
    }

    boolean beforeRenderBody() {
        return false;
    }

    Binding defaultValidate() {
        return this.defaultProvider.defaultValidatorBinding("selected", this.resources);
    }

    String toClient(Object value) {
        return this.encoder.toClient(value);
    }

    @Override
    public boolean isRequired() {
        return this.validate.isRequired();
    }

    public String getDisabledValue() {
        return this.disabled ? "disabled" : null;
    }

    void onBeginRenderFromSelected(MarkupWriter writer) {
        this.validate.render(writer);
    }
}

