/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.tinkerpop.gremlin.driver;

import org.apache.tinkerpop.gremlin.driver.exception.ConnectionException;

/**
 * A factory that is responsible for creating a {@link Connection} instance. The {@link DefaultConnectionFactory}
 * simply news up a {@code Connection} using its default constructor. This interface is mostly present to help
 * enable better testing of the driver internals and likely shouldn't be used otherwise.
 */
interface ConnectionFactory {

    /**
     * Create a connection for the specified {@link ConnectionPool}.
     */
    public default Connection create(final ConnectionPool pool) throws ConnectionException {
        return new Connection(pool.host.getHostUri(), pool, pool.settings().maxInProcessPerConnection);
    }

    /**
     * Default implementation.
     */
    public static class DefaultConnectionFactory implements ConnectionFactory { }
}
