/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.language.translator;

import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParser;
import org.apache.tinkerpop.gremlin.language.translator.AbstractTranslateVisitor;
import org.apache.tinkerpop.gremlin.language.translator.TranslatorException;
import org.apache.tinkerpop.gremlin.util.DatetimeHelper;

public class JavascriptTranslateVisitor
extends AbstractTranslateVisitor {
    public JavascriptTranslateVisitor() {
        this("g");
    }

    public JavascriptTranslateVisitor(String graphTraversalSourceName) {
        super(graphTraversalSourceName);
    }

    public Void visitTraversalStrategy(GremlinParser.TraversalStrategyContext ctx) {
        this.sb.append("new ");
        if (ctx.getChildCount() == 1) {
            this.sb.append(ctx.getText()).append("()");
        } else {
            this.sb.append(ctx.getChild(0).getText().equals("new") ? ctx.getChild(1).getText() : ctx.getChild(0).getText()).append("({");
            List configs = ctx.children.stream().filter(c -> c instanceof GremlinParser.ConfigurationContext).collect(Collectors.toList());
            for (int ix = 0; ix < configs.size(); ++ix) {
                this.visit((ParseTree)configs.get(ix));
                if (ix >= configs.size() - 1) continue;
                this.sb.append(", ");
            }
            this.sb.append("})");
        }
        return null;
    }

    public Void visitConfiguration(GremlinParser.ConfigurationContext ctx) {
        this.sb.append(SymbolHelper.toJavascript(ctx.getChild(0).getText()));
        this.sb.append(": ");
        this.visit(ctx.getChild(2));
        return null;
    }

    @Override
    public Void visitTraversalGType(GremlinParser.TraversalGTypeContext ctx) {
        String[] split = ctx.getText().split("\\.");
        this.sb.append(this.processGremlinSymbol(split[0])).append(".");
        this.sb.append(this.processGremlinSymbol(split[1].toLowerCase()));
        return null;
    }

    public Void visitGenericMapLiteral(GremlinParser.GenericMapLiteralContext ctx) {
        this.sb.append("new Map([");
        for (int i = 0; i < ctx.mapEntry().size(); ++i) {
            GremlinParser.MapEntryContext mapEntryContext = ctx.mapEntry(i);
            this.visit((ParseTree)mapEntryContext);
            if (i >= ctx.mapEntry().size() - 1) continue;
            this.sb.append(", ");
        }
        this.sb.append("])");
        return null;
    }

    public Void visitMapEntry(GremlinParser.MapEntryContext ctx) {
        boolean isKeyWrappedInParens = ctx.getChild(0).getText().equals("(");
        this.sb.append("[");
        this.visit((ParseTree)ctx.mapKey());
        this.sb.append(", ");
        this.visit((ParseTree)ctx.genericLiteral());
        this.sb.append("]");
        return null;
    }

    public Void visitMapKey(GremlinParser.MapKeyContext ctx) {
        int keyIndex = ctx.LPAREN() != null && ctx.RPAREN() != null ? 1 : 0;
        this.visit(ctx.getChild(keyIndex));
        return null;
    }

    public Void visitDateLiteral(GremlinParser.DateLiteralContext ctx) {
        String dtString = ctx.getChild(2).getText();
        OffsetDateTime dt = DatetimeHelper.parse(JavascriptTranslateVisitor.removeFirstAndLastCharacters(dtString));
        this.sb.append("new Date('");
        this.sb.append(dt);
        this.sb.append("')");
        return null;
    }

    @Override
    public Void visitNanLiteral(GremlinParser.NanLiteralContext ctx) {
        this.sb.append("Number.NaN");
        return null;
    }

    @Override
    public Void visitInfLiteral(GremlinParser.InfLiteralContext ctx) {
        if (ctx.SignedInfLiteral() != null && ctx.SignedInfLiteral().getText().equals("-Infinity")) {
            this.sb.append("Number.NEGATIVE_INFINITY");
        } else {
            this.sb.append("Number.POSITIVE_INFINITY");
        }
        return null;
    }

    @Override
    public Void visitIntegerLiteral(GremlinParser.IntegerLiteralContext ctx) {
        int lastCharIndex;
        String integerLiteral = ctx.getText().toLowerCase();
        char lastChar = integerLiteral.charAt(lastCharIndex = integerLiteral.length() - 1);
        if (Character.isAlphabetic(lastChar)) {
            this.sb.append(integerLiteral, 0, lastCharIndex);
        } else {
            this.sb.append(integerLiteral);
        }
        return null;
    }

    @Override
    public Void visitFloatLiteral(GremlinParser.FloatLiteralContext ctx) {
        int lastCharIndex;
        if (ctx.infLiteral() != null) {
            return (Void)this.visit((ParseTree)ctx.infLiteral());
        }
        if (ctx.nanLiteral() != null) {
            return (Void)this.visit((ParseTree)ctx.nanLiteral());
        }
        String floatLiteral = ctx.getText().toLowerCase();
        char lastChar = floatLiteral.charAt(lastCharIndex = floatLiteral.length() - 1);
        if (Character.isAlphabetic(lastChar)) {
            this.sb.append(floatLiteral, 0, lastCharIndex);
        } else {
            this.sb.append(floatLiteral);
        }
        return null;
    }

    public Void visitGenericRangeLiteral(GremlinParser.GenericRangeLiteralContext ctx) {
        throw new TranslatorException("Javascript does not support range literals");
    }

    public Void visitGenericSetLiteral(GremlinParser.GenericSetLiteralContext ctx) {
        this.sb.append("new Set([");
        for (int i = 0; i < ctx.genericLiteral().size(); ++i) {
            GremlinParser.GenericLiteralContext genericLiteralContext = ctx.genericLiteral(i);
            this.visit((ParseTree)genericLiteralContext);
            if (i >= ctx.genericLiteral().size() - 1) continue;
            this.sb.append(", ");
        }
        this.sb.append("])");
        return null;
    }

    public Void visitGenericCollectionLiteral(GremlinParser.GenericCollectionLiteralContext ctx) {
        this.sb.append("[");
        for (int i = 0; i < ctx.genericLiteral().size(); ++i) {
            GremlinParser.GenericLiteralContext genericLiteralContext = ctx.genericLiteral(i);
            this.visit((ParseTree)genericLiteralContext);
            if (i >= ctx.genericLiteral().size() - 1) continue;
            this.sb.append(", ");
        }
        this.sb.append("]");
        return null;
    }

    @Override
    public Void visitUuidLiteral(GremlinParser.UuidLiteralContext ctx) {
        if (ctx.stringLiteral() == null) {
            this.sb.append("uuid.v4()");
            return null;
        }
        this.visitStringLiteral(ctx.stringLiteral());
        return null;
    }

    @Override
    protected String getCardinalityFunctionClass() {
        return "CardinalityValue";
    }

    @Override
    protected String processGremlinSymbol(String step) {
        return SymbolHelper.toJavascript(step);
    }

    private void wrapTextInQuotes(String text) {
        this.sb.append("\"");
        this.sb.append(text);
        this.sb.append("\"");
    }

    static final class SymbolHelper {
        private static final Map<String, String> TO_JS_MAP = new HashMap<String, String>();
        private static final Map<String, String> FROM_JS_MAP = new HashMap<String, String>();

        private SymbolHelper() {
        }

        public static String toJavascript(String symbol) {
            return TO_JS_MAP.getOrDefault(symbol, symbol);
        }

        public static String toJava(String symbol) {
            return FROM_JS_MAP.getOrDefault(symbol, symbol);
        }

        static {
            TO_JS_MAP.put("from", "from_");
            TO_JS_MAP.put("in", "in_");
            TO_JS_MAP.put("with", "with_");
            TO_JS_MAP.put("bigdecimal", "bigDecimal");
            TO_JS_MAP.put("bigint", "bigInt");
            TO_JS_MAP.forEach((k, v) -> FROM_JS_MAP.put((String)v, (String)k));
        }
    }
}

