/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.filter;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValueHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.TailGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.TailGlobalStepContract;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;

public final class TailGlobalStepPlaceholder<S>
extends AbstractStep<S, S>
implements TailGlobalStepContract<S>,
GValueHolder<S, S> {
    private GValue<Long> limit;
    private boolean bypass = false;

    public TailGlobalStepPlaceholder(Traversal.Admin traversal, GValue<Long> limit) {
        super(traversal);
        if (null == limit) {
            throw new IllegalArgumentException("TailGlobalStepPlaceholder requires limit to be non-null");
        }
        this.limit = limit;
        if (this.limit.isVariable()) {
            traversal.getGValueManager().register(limit);
        }
    }

    @Override
    public Traverser.Admin<S> processNextStart() {
        throw new IllegalStateException("GValueHolder is not executable");
    }

    @Override
    public void setBypass(boolean bypass) {
        this.bypass = bypass;
    }

    @Override
    public TailGlobalStepPlaceholder<S> clone() {
        TailGlobalStepPlaceholder clone = (TailGlobalStepPlaceholder)super.clone();
        clone.limit = this.limit.clone();
        clone.bypass = this.bypass;
        return clone;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TailGlobalStepPlaceholder that = (TailGlobalStepPlaceholder)o;
        return this.bypass == that.bypass && Objects.equals(this.limit, that.limit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.limit, this.bypass);
    }

    @Override
    public Long getLimit() {
        if (this.limit.isVariable()) {
            this.traversal.getGValueManager().pinVariable(this.limit.getName());
        }
        return this.limit.get();
    }

    @Override
    public GValue<Long> getLimitAsGValue() {
        return this.limit;
    }

    @Override
    public MemoryComputeKey<TraverserSet<S>> getMemoryComputeKey() {
        return MemoryComputeKey.of(this.getId(), new RangeGlobalStep.RangeBiOperator(this.limit.get()), false, true);
    }

    @Override
    public void processAllStarts() {
        throw new IllegalStateException("TailGlobalStepPlaceholder is not executable");
    }

    @Override
    public Step<S, S> asConcreteStep() {
        TailGlobalStep step = new TailGlobalStep(this.traversal, this.limit.get());
        TraversalHelper.copyLabels(this, step, false);
        step.setBypass(this.bypass);
        return step;
    }

    @Override
    public boolean isParameterized() {
        return this.limit.isVariable();
    }

    @Override
    public void updateVariable(String name, Object value) {
        if (name.equals(this.limit.getName())) {
            if (!(value instanceof Number)) {
                throw new IllegalArgumentException("The variable " + name + " must have a value of type Number");
            }
            this.limit = GValue.ofLong(name, ((Number)value).longValue());
        }
    }

    @Override
    public Collection<GValue<?>> getGValues() {
        return Collections.singletonList(this.limit);
    }
}

