/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.math.BigInteger;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.DatetimeHelper;

public final class AsDateStep<S>
extends ScalarMapStep<S, OffsetDateTime> {
    public AsDateStep(Traversal.Admin traversal) {
        super(traversal);
    }

    @Override
    protected OffsetDateTime map(Traverser.Admin<S> traverser) {
        Object object = traverser.get();
        if (object == null) {
            throw new IllegalArgumentException("Can't parse null as OffsetDateTime.");
        }
        if (object instanceof Date) {
            return OffsetDateTime.ofInstant(((Date)object).toInstant(), ZoneOffset.UTC);
        }
        if (object instanceof OffsetDateTime) {
            return (OffsetDateTime)object;
        }
        if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long) {
            return OffsetDateTime.ofInstant(Instant.ofEpochMilli(((Number)object).longValue()), ZoneOffset.UTC);
        }
        if (object instanceof BigInteger) {
            try {
                return OffsetDateTime.ofInstant(Instant.ofEpochMilli(((BigInteger)object).longValueExact()), ZoneOffset.UTC);
            }
            catch (ArithmeticException ae) {
                throw new IllegalArgumentException("Can't parse " + object + " as OffsetDateTime.");
            }
        }
        if (object instanceof String) {
            try {
                return DatetimeHelper.parse((String)object);
            }
            catch (DateTimeParseException e) {
                throw new IllegalArgumentException("Can't parse " + object + " as OffsetDateTime.");
            }
        }
        throw new IllegalArgumentException("Can't parse " + object.getClass().getName() + " as OffsetDateTime.");
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, new Object[0]);
    }
}

