/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValueHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.RangeLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.RangeLocalStepContract;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;

public class RangeLocalStepPlaceholder<S>
extends ScalarMapStep<S, S>
implements RangeLocalStepContract<S>,
GValueHolder<S, S> {
    protected GValue<Long> low;
    protected GValue<Long> high;

    public RangeLocalStepPlaceholder(Traversal.Admin traversal, GValue<Long> low, GValue<Long> high) {
        super(traversal);
        if (null == low || null == high) {
            throw new IllegalArgumentException("RangeLocalStepPlaceholder requires both low and high values to be non-null");
        }
        this.low = low;
        this.high = high;
        traversal.getGValueManager().register(low);
        traversal.getGValueManager().register(high);
    }

    @Override
    public boolean isParameterized() {
        return this.low.isVariable() || this.high.isVariable();
    }

    @Override
    public void updateVariable(String name, Object value) {
        if (name.equals(this.low.getName())) {
            if (!(value instanceof Number)) {
                throw new IllegalArgumentException("The variable " + name + " must have a value of type Number");
            }
            this.low = GValue.ofLong(name, ((Number)value).longValue());
        }
        if (name.equals(this.high.getName())) {
            if (!(value instanceof Number)) {
                throw new IllegalArgumentException("The variable " + name + " must have a value of type Number");
            }
            this.high = GValue.ofLong(name, ((Number)value).longValue());
        }
    }

    @Override
    public Long getLowRange() {
        if (this.low.isVariable()) {
            this.traversal.getGValueManager().pinVariable(this.low.getName());
        }
        return this.low.get();
    }

    @Override
    public Long getHighRange() {
        if (this.high.isVariable()) {
            this.traversal.getGValueManager().pinVariable(this.high.getName());
        }
        return this.high.get();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RangeLocalStepPlaceholder that = (RangeLocalStepPlaceholder)o;
        return Objects.equals(this.low, that.low) && Objects.equals(this.high, that.high);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.low, this.high);
    }

    @Override
    public GValue<Long> getLowRangeAsGValue() {
        return this.low;
    }

    @Override
    public GValue<Long> getHighRangeAsGValue() {
        return this.high;
    }

    @Override
    protected S map(Traverser.Admin<S> traverser) {
        throw new IllegalStateException("RangeLocalStepPlaceholder is not executable");
    }

    @Override
    public Collection<GValue<?>> getGValues() {
        HashSet gValues = new HashSet();
        if (this.low.isVariable()) {
            gValues.add(this.low);
        }
        if (this.high.isVariable()) {
            gValues.add(this.high);
        }
        return gValues;
    }

    public RangeLocalStep<S> asConcreteStep() {
        RangeLocalStep step = new RangeLocalStep(this.traversal, this.low.get(), this.high.get());
        TraversalHelper.copyLabels(this, step, false);
        return step;
    }

    @Override
    public RangeLocalStepPlaceholder<S> clone() {
        RangeLocalStepPlaceholder clone = (RangeLocalStepPlaceholder)super.clone();
        clone.low = this.low.clone();
        clone.high = this.high.clone();
        return clone;
    }
}

