/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.finalization;

import org.apache.commons.configuration2.Configuration;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MatchStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class MatchAlgorithmStrategy
extends AbstractTraversalStrategy<TraversalStrategy.FinalizationStrategy>
implements TraversalStrategy.FinalizationStrategy {
    private static final String MATCH_ALGORITHM = "matchAlgorithm";
    private Class<? extends MatchStep.MatchAlgorithm> matchAlgorithmClass;

    private MatchAlgorithmStrategy() {
    }

    private MatchAlgorithmStrategy(Class<? extends MatchStep.MatchAlgorithm> matchAlgorithmClass) {
        this.matchAlgorithmClass = matchAlgorithmClass;
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        for (Step step : traversal.getSteps()) {
            if (!(step instanceof MatchStep)) continue;
            ((MatchStep)step).setMatchAlgorithm(this.matchAlgorithmClass);
        }
    }

    public static MatchAlgorithmStrategy create(Configuration configuration) {
        try {
            return new MatchAlgorithmStrategy(Class.forName(configuration.getString(MATCH_ALGORITHM)));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public Class<? extends MatchStep.MatchAlgorithm> getMatchAlgorithmClass() {
        return this.matchAlgorithmClass;
    }

    @Override
    public Configuration getConfiguration() {
        Configuration config = super.getConfiguration();
        config.setProperty(MATCH_ALGORITHM, (Object)this.matchAlgorithmClass.getName());
        return config;
    }

    public static Builder build() {
        return new Builder();
    }

    @Override
    public String toString() {
        return StringFactory.traversalStrategyString(this);
    }

    public static final class Builder {
        private Class<? extends MatchStep.MatchAlgorithm> matchAlgorithmClass = MatchStep.CountMatchAlgorithm.class;

        private Builder() {
        }

        public Builder algorithm(Class<? extends MatchStep.MatchAlgorithm> matchAlgorithmClass) {
            this.matchAlgorithmClass = matchAlgorithmClass;
            return this;
        }

        public MatchAlgorithmStrategy create() {
            return new MatchAlgorithmStrategy(this.matchAlgorithmClass);
        }
    }
}

