/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.propertyeditor;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.util.List;
import java.util.ListIterator;
import org.apache.xbean.propertyeditor.AbstractCollectionConverter;
import org.apache.xbean.propertyeditor.StringEditor;

public final class PrototypeArrayConverter
extends AbstractCollectionConverter {
    private static final PropertyEditor MOCK_EDITOR = new StringEditor();

    public PrototypeArrayConverter(Class type) {
        super(type, MOCK_EDITOR);
        if (!type.isArray()) {
            throw new IllegalArgumentException("type is not an array " + type.getSimpleName());
        }
        if (type.getComponentType().isArray()) {
            throw new IllegalArgumentException("type is a multi-dimensional array " + type.getSimpleName());
        }
    }

    @Override
    protected PropertyEditor getEditor() {
        return PropertyEditorManager.findEditor(this.getType());
    }

    @Override
    protected Object createCollection(List list) {
        Object array = Array.newInstance(this.getType().getComponentType(), list.size());
        ListIterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            int index = iterator.previousIndex();
            Array.set(array, index, item);
        }
        return array;
    }
}

