package org.apache.stratum.component;

/*
 * Copyright 2001-2005 The Apache Software Foundation or its licensors,
 * as applicable.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import junit.framework.Assert;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.exception.NestableException;
import org.apache.log4j.Category;
import org.apache.stratum.lifecycle.Configurable;
import org.apache.stratum.lifecycle.Initializable;

/**
 * This class is used by TestComponentLoader to test some assertions about the behvior of ComponentLoader.
 *
 * @author <a href="mailto:eric NOSPAM dobbse.net">Eric Dobbs</a>
 * @version $Id: MockComponent.java 264191 2005-08-29 18:07:52Z henning $
 */
public class MockComponent
        extends Assert
        implements Configurable, Initializable
{
    /** TODO: DOCUMENT ME! */
    private static Category log = Category.getInstance(MockComponent.class);

    /** TODO: DOCUMENT ME! */
    private int callsToConfigure = 0;

    /** TODO: DOCUMENT ME! */
    private int callsToInitialize = 0;

    /** TODO: DOCUMENT ME! */
    private int expectedCallsToConfigure = 1;

    /** TODO: DOCUMENT ME! */
    private int expectedCallsToInitialize = 1;

    /** TODO: DOCUMENT ME! */
    private Configuration config = null;

    /**
     * Verify that the given Configuration is not null and that configure() is called only once.
     *
     * @param configuration TODO: DOCUMENT ME!
     *
     * @throws NestableException TODO: DOCUMENT ME!
     */
    public void configure(Configuration configuration)
            throws NestableException
    {
        log.debug("MockComponent.configure() called");

        config = configuration;

        assertNotNull(configuration);
        log.debug("good news!  configuration not null");

        callsToConfigure++;

        if (callsToConfigure > expectedCallsToConfigure)
        {
            log.debug("bad news!  configure() called too many times");
            fail("configure() called too many times");
        }

        log.debug("good news!  configure() called successfully");
    }

    /**
     * Verify that initialize() is called only once.
     *
     * @throws Exception TODO: DOCUMENT ME!
     */
    public void initialize()
            throws Exception
    {
        log.debug("MockComponent.initialize() called");

        callsToInitialize++;

        if (callsToInitialize > expectedCallsToInitialize)
        {
            log.debug("bad news!  initialize() called too many times");
            fail("initialize() called too many times");
        }

        log.debug("good news!  initialize() called successfully");
    }

    /**
     * TODO: DOCUMENT ME!
     *
     * @return TODO: DOCUMENT ME!
     */
    public Configuration getConfiguration()
    {
        return config;
    }
}
