/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.validation.SchemaFactory;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.apache.fulcrum.intake.IntakeException;
import org.apache.fulcrum.intake.IntakeService;
import org.apache.fulcrum.intake.IntakeServiceFacade;
import org.apache.fulcrum.intake.model.AppData;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.Group;

public class IntakeServiceImpl
extends AbstractLogEnabled
implements IntakeService,
Configurable,
Initializable,
Contextualizable,
Serviceable {
    private Map<String, AppData> groupNames;
    private Map<String, String> groupNameMap;
    private Map<String, String> groupKeyMap;
    private Map<String, Map<String, Method>> getterMap;
    private Map<String, Map<String, Method>> setterMap;
    private Map<AppData, KeyedObjectPool<String, Group>> keyedPools;
    private String applicationRoot;
    private List<String> xmlPathes = null;
    private String serialDataPath = null;

    private boolean registerGroup(String groupName, Group group, AppData appData, boolean checkKey) {
        if (this.groupNames.containsKey(groupName)) {
            return false;
        }
        boolean keyExists = this.groupNameMap.containsKey(group.getGID());
        if (checkKey && keyExists) {
            return false;
        }
        this.groupNames.put(groupName, appData);
        this.groupKeyMap.put(groupName, group.getGID());
        if (!keyExists) {
            this.groupNameMap.put(group.getGID(), groupName);
        }
        List<Field<?>> fields = group.getFields();
        for (Field<?> field : fields) {
            String className = field.getMapToObject();
            if (this.getterMap.containsKey(className)) continue;
            this.getterMap.put(className, new HashMap());
            this.setterMap.put(className, new HashMap());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<AppData, File> loadSerialized(String serialDataPath, long timeStamp) {
        this.getLogger().debug("Entered loadSerialized(" + serialDataPath + ", " + timeStamp + ")");
        long timer = System.currentTimeMillis();
        if (serialDataPath == null) {
            return null;
        }
        File serialDataFile = new File(serialDataPath);
        if (!serialDataFile.exists()) {
            this.getLogger().info("No serialized file found, parsing XML");
            return null;
        }
        if (serialDataFile.lastModified() <= timeStamp) {
            this.getLogger().info("serialized file too old, parsing XML");
            return null;
        }
        ObjectInputStream in = null;
        Map serialData = null;
        try {
            FileInputStream fin = new FileInputStream(serialDataFile);
            in = new ObjectInputStream(fin);
            Object o = in.readObject();
            if (o instanceof Map) {
                Map map;
                serialData = map = (Map)o;
            } else {
                this.getLogger().info("serialized object is not an intake map, ignoring");
                in.close();
                in = null;
                boolean result = serialDataFile.delete();
                if (!result) {
                    this.getLogger().error("Unknown serialized file could not be removed");
                }
            }
        }
        catch (IOException e) {
            this.getLogger().error("Serialized File could not be read.", (Throwable)e);
            serialData = null;
        }
        catch (ClassNotFoundException e) {
            this.getLogger().error("Objects could not be read from serialized file.", (Throwable)e);
            serialData = null;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                this.getLogger().error("Exception while closing file", (Throwable)e);
            }
        }
        if (serialData != null) {
            for (AppData appData : serialData.keySet()) {
                for (Group group : appData.getGroups()) {
                    if (group instanceof LogEnabled) {
                        group.enableLogging(this.getLogger());
                    }
                    for (Field<?> field : group.getFields()) {
                        if (!(field instanceof LogEnabled)) continue;
                        field.enableLogging(this.getLogger());
                    }
                }
            }
        }
        this.getLogger().info("Loaded serialized map object, ignoring XML");
        this.getLogger().debug("Loading took " + (System.currentTimeMillis() - timer));
        return serialData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSerialized(String serialDataPath, Map<AppData, File> appDataElements) {
        this.getLogger().debug("Entered saveSerialized(" + serialDataPath + ", appDataElements)");
        long timer = System.currentTimeMillis();
        if (serialDataPath == null) {
            return;
        }
        File serialData = new File(serialDataPath);
        try {
            boolean result = serialData.createNewFile();
            if (!result) {
                this.getLogger().error("Could not create new serialized file");
            }
            if (!(result = serialData.delete())) {
                this.getLogger().error("Serialized file could not be removed");
            }
        }
        catch (IOException e) {
            this.getLogger().info("Could not create serialized file " + serialDataPath + ", not serializing the XML data", (Throwable)e);
            return;
        }
        ObjectOutputStream out = null;
        ObjectInputStream in = null;
        try {
            FileOutputStream fout = new FileOutputStream(serialDataPath);
            out = new ObjectOutputStream(fout);
            out.writeObject(appDataElements);
            out.flush();
            FileInputStream fin = new FileInputStream(serialDataPath);
            in = new ObjectInputStream(fin);
            in.readObject();
            this.getLogger().debug("Serializing successful");
        }
        catch (IOException e) {
            this.getLogger().info("Could not write serialized file to " + serialDataPath + ", not serializing the XML data", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            this.getLogger().info("Could not re-read serialized file from " + serialDataPath, (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                this.getLogger().error("Exception while closing file", (Throwable)e);
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                this.getLogger().error("Exception while closing file", (Throwable)e);
            }
        }
        this.getLogger().debug("Saving took " + (System.currentTimeMillis() - timer));
    }

    @Override
    public Group getGroup(String groupName) throws IntakeException {
        Group group = null;
        AppData appData = this.groupNames.get(groupName);
        if (groupName == null) {
            throw new IntakeException("Intake IntakeServiceImpl.getGroup(groupName) is null");
        }
        if (appData == null) {
            throw new IntakeException("Intake IntakeServiceImpl.getGroup(groupName): No XML definition for Group " + groupName + " found");
        }
        try {
            group = (Group)this.keyedPools.get(appData).borrowObject((Object)groupName);
        }
        catch (Exception e) {
            throw new IntakeException("Could not get group " + groupName, e);
        }
        return group;
    }

    @Override
    public void releaseGroup(Group instance) throws IntakeException {
        if (instance != null) {
            String groupName = instance.getIntakeGroupName();
            AppData appData = this.groupNames.get(groupName);
            if (appData == null) {
                throw new IntakeException("Intake IntakeServiceImpl.releaseGroup(groupName): No XML definition for Group " + groupName + " found");
            }
            try {
                this.keyedPools.get(appData).returnObject((Object)groupName, (Object)instance);
            }
            catch (Exception e) {
                throw new IntakeException("Could not get group " + groupName, e);
            }
        }
    }

    @Override
    public int getSize(String groupName) throws IntakeException {
        AppData appData = this.groupNames.get(groupName);
        if (appData == null) {
            throw new IntakeException("Intake IntakeServiceImpl.Size(groupName): No XML definition for Group " + groupName + " found");
        }
        KeyedObjectPool<String, Group> kop = this.keyedPools.get(appData);
        return kop.getNumActive((Object)groupName) + kop.getNumIdle((Object)groupName);
    }

    @Override
    public String[] getGroupNames() {
        return this.groupNames.keySet().toArray(new String[0]);
    }

    @Override
    public String getGroupKey(String groupName) {
        return this.groupKeyMap.get(groupName);
    }

    @Override
    public String getGroupName(String groupKey) {
        return this.groupNameMap.get(groupKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Method getFieldSetter(String className, String propName) throws ClassNotFoundException, IntrospectionException {
        Map<String, Method> settersForClassName = this.setterMap.get(className);
        if (settersForClassName == null) {
            throw new IntrospectionException("No setter Map for " + className + " available!");
        }
        Method setter = settersForClassName.get(propName);
        if (setter == null) {
            PropertyDescriptor pd = new PropertyDescriptor(propName, Class.forName(className));
            Map<String, Map<String, Method>> map = this.setterMap;
            synchronized (map) {
                setter = pd.getWriteMethod();
                settersForClassName.put(propName, setter);
                if (setter == null) {
                    this.getLogger().error("Intake: setter for '" + propName + "' in class '" + className + "' could not be found.");
                }
            }
            map = this.getterMap;
            synchronized (map) {
                Method getter;
                Map<String, Method> gettersForClassName = this.getterMap.get(className);
                if (gettersForClassName != null && (getter = pd.getReadMethod()) != null) {
                    gettersForClassName.put(propName, getter);
                }
            }
        }
        return setter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Method getFieldGetter(String className, String propName) throws ClassNotFoundException, IntrospectionException {
        Map<String, Method> gettersForClassName = this.getterMap.get(className);
        if (gettersForClassName == null) {
            throw new IntrospectionException("No getter Map for " + className + " available!");
        }
        Method getter = gettersForClassName.get(propName);
        if (getter == null) {
            PropertyDescriptor pd = null;
            Map<String, Map<String, Method>> map = this.getterMap;
            synchronized (map) {
                pd = new PropertyDescriptor(propName, Class.forName(className));
                getter = pd.getReadMethod();
                gettersForClassName.put(propName, getter);
                if (getter == null) {
                    this.getLogger().error("Intake: getter for '" + propName + "' in class '" + className + "' could not be found.");
                }
            }
            map = this.setterMap;
            synchronized (map) {
                Method setter;
                Map<String, Method> settersForClassName = this.getterMap.get(className);
                if (settersForClassName != null && (setter = pd.getWriteMethod()) != null) {
                    settersForClassName.put(propName, setter);
                }
            }
        }
        return getter;
    }

    public void configure(Configuration conf) throws ConfigurationException {
        Configuration xmlPaths = conf.getChild("xmlPaths", false);
        this.xmlPathes = new ArrayList<String>();
        if (xmlPaths == null) {
            this.xmlPathes.add("WEB-INF/conf/intake.xml");
        } else {
            Configuration[] nameVal = xmlPaths.getChildren();
            for (int i = 0; i < nameVal.length; ++i) {
                String val = nameVal[i].getValue();
                this.xmlPathes.add(val);
            }
        }
        this.serialDataPath = conf.getChild("serialDataPath", false).getValue("WEB-INF/appData.ser");
        this.serialDataPath = !this.serialDataPath.equalsIgnoreCase("none") ? new File(this.applicationRoot, this.serialDataPath).getAbsolutePath() : null;
        this.getLogger().debug("Path for serializing: " + this.serialDataPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws Exception {
        Map<AppData, File> appDataElements = null;
        this.groupNames = new HashMap<String, AppData>();
        this.groupKeyMap = new HashMap<String, String>();
        this.groupNameMap = new HashMap<String, String>();
        this.getterMap = new HashMap<String, Map<String, Method>>();
        this.setterMap = new HashMap<String, Map<String, Method>>();
        this.keyedPools = new HashMap<AppData, KeyedObjectPool<String, Group>>();
        HashSet<File> xmlFiles = new HashSet<File>();
        long timeStamp = 0L;
        for (String xmlPath : this.xmlPathes) {
            File xmlFile = new File(this.applicationRoot, xmlPath).getAbsoluteFile();
            this.getLogger().debug("Path for XML File: " + xmlFile);
            if (!xmlFile.canRead()) {
                String READ_ERR = "Could not read input file with path " + xmlPath + ".  Looking for file " + xmlFile;
                this.getLogger().error(READ_ERR);
                throw new Exception(READ_ERR);
            }
            xmlFiles.add(xmlFile);
            this.getLogger().debug("Added " + xmlPath + " as File to parse");
            timeStamp = xmlFile.lastModified() > timeStamp ? xmlFile.lastModified() : timeStamp;
        }
        Map<AppData, File> serializedMap = this.loadSerialized(this.serialDataPath, timeStamp);
        if (serializedMap != null) {
            appDataElements = serializedMap;
            this.getLogger().debug("Using the serialized map");
        } else {
            long timer = System.currentTimeMillis();
            JAXBContext jaxb = JAXBContext.newInstance((Class[])new Class[]{AppData.class});
            Unmarshaller um = jaxb.createUnmarshaller();
            um.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            AvalonLogEnabledListener logEnabledListener = new AvalonLogEnabledListener();
            um.setListener((Unmarshaller.Listener)logEnabledListener);
            URL schemaURL = this.getClass().getResource("/intake.xsd");
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            um.setSchema(schemaFactory.newSchema(schemaURL));
            appDataElements = new HashMap<AppData, File>();
            for (File xmlFile : xmlFiles) {
                this.getLogger().debug("Now parsing: " + xmlFile);
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(xmlFile);
                    AppData appData = (AppData)um.unmarshal((InputStream)fis);
                    appDataElements.put(appData, xmlFile);
                    this.getLogger().debug("Saving AppData for " + xmlFile);
                }
                finally {
                    if (fis == null) continue;
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        this.getLogger().warn("Could not close file " + xmlFile);
                    }
                }
            }
            this.getLogger().debug("Parsing took " + (System.currentTimeMillis() - timer));
            this.saveSerialized(this.serialDataPath, appDataElements);
        }
        int counter = 0;
        for (Map.Entry<AppData, File> entry : appDataElements.entrySet()) {
            AppData appData = entry.getKey();
            File dataFile = entry.getValue();
            int maxPooledGroups = 0;
            List<Group> glist = appData.getGroups();
            String groupPrefix = appData.getGroupPrefix();
            ListIterator<Group> i = glist.listIterator(glist.size());
            while (i.hasPrevious()) {
                Group g = i.previous();
                String groupName = g.getIntakeGroupName();
                boolean registerUnqualified = this.registerGroup(groupName, g, appData, true);
                if (!registerUnqualified) {
                    this.getLogger().info("Ignored redefinition of Group " + groupName + " or Key " + g.getGID() + " from " + dataFile);
                }
                if (groupPrefix != null) {
                    StringBuilder qualifiedName = new StringBuilder();
                    qualifiedName.append(groupPrefix).append(':').append(groupName);
                    if (!this.registerGroup(qualifiedName.toString(), g, appData, !registerUnqualified)) {
                        this.getLogger().error("Could not register fully qualified name " + qualifiedName + ", maybe two XML files have the same prefix. Ignoring it.");
                    }
                }
                for (Field<?> f : g.getFields()) {
                    f.initGetterAndSetter();
                }
                maxPooledGroups = Math.max(maxPooledGroups, g.getPoolCapacity());
            }
            Group.GroupFactory factory = new Group.GroupFactory(appData);
            GenericKeyedObjectPoolConfig poolConfig = new GenericKeyedObjectPoolConfig();
            poolConfig.setMaxTotalPerKey(maxPooledGroups);
            poolConfig.setJmxEnabled(true);
            poolConfig.setJmxNamePrefix("fulcrum-intake-pool-" + counter++);
            this.keyedPools.put(appData, (KeyedObjectPool<String, Group>)new GenericKeyedObjectPool((KeyedPooledObjectFactory)factory, poolConfig));
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Intake Service is initialized now.");
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.applicationRoot = context.get((Object)"urn:avalon:home").toString();
    }

    public void service(ServiceManager manager) throws ServiceException {
        IntakeServiceFacade.setIntakeService(this);
    }

    private class AvalonLogEnabledListener
    extends Unmarshaller.Listener {
        private AvalonLogEnabledListener() {
        }

        public void beforeUnmarshal(Object target, Object parent) {
            super.beforeUnmarshal(target, parent);
            if (target instanceof LogEnabled) {
                ((LogEnabled)target).enableLogging(IntakeServiceImpl.this.getLogger());
            }
        }
    }
}

