/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;

public abstract class ObjectUtils {
    public static byte[] serializeMap(Map<String, Object> map) throws Exception {
        byte[] byteArray = null;
        for (Object value : map.values()) {
            if (value instanceof Serializable) continue;
            throw new Exception("Could not serialize, value is not serializable:" + value);
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
             ObjectOutputStream out = new ObjectOutputStream(baos);){
            out.writeObject(map);
            out.flush();
            byteArray = baos.toByteArray();
        }
        return byteArray;
    }

    public static <T> T deserialize(byte[] objectData) {
        Object object = null;
        if (objectData != null) {
            try (ByteArrayInputStream bin = new ByteArrayInputStream(objectData);
                 ObjectInputStream in = new ObjectInputStream(bin);){
                object = in.readObject();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (T)object;
    }
}

