/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.tools;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.uima.ruta.textruler.TextRulerPlugin;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;
import org.apache.uima.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSetGenerator {
    public static String trainingDir = "/Users/tobi/Documents/UniLaptop/Diplomarbeit/TestDataSets/withPosTags/ALL/training/";
    public static String testDir = "/Users/tobi/Documents/UniLaptop/Diplomarbeit/TestDataSets/withPosTags/ALL/withoutslots/";
    public static String trainingFilesPrefix = "postagged_";
    public static String testFilesPrefix = "postagged_withoutslots_";

    public static void main(String[] args) {
        File trainingFolder = new File(trainingDir);
        File[] files = trainingFolder.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".xmi");
            }
        });
        ArrayList<PairEntry> pairs = new ArrayList<PairEntry>();
        for (File file : files) {
            String fName = file.getName();
            String docName = fName.substring(trainingFilesPrefix.length());
            PairEntry p = new PairEntry();
            p.trainingsFileName = fName;
            p.testFileName = testFilesPrefix + docName;
            pairs.add(p);
        }
        try {
            Random rand = new Random();
            ArrayList<PairEntry> list1 = new ArrayList<PairEntry>(pairs);
            ArrayList<PairEntry> list2 = new ArrayList<PairEntry>();
            for (int i = 0; i < 28; ++i) {
                int index = rand.nextInt(list1.size());
                list2.add((PairEntry)list1.get(index));
                list1.remove(index);
            }
            while (list1.size() > 252) {
                int index = rand.nextInt(list1.size());
                list1.remove(index);
            }
            TestSetGenerator.copyPairs(list1, "/Users/tobi/Documents/UniLaptop/Diplomarbeit/TestDataSets/withPosTags/9010_middle/0/training");
            TestSetGenerator.copyPairs(list2, "/Users/tobi/Documents/UniLaptop/Diplomarbeit/TestDataSets/withPosTags/9010_middle/0/testing");
        }
        catch (Exception e) {
            TextRulerPlugin.error(e);
        }
    }

    public static void copyPairs(List<PairEntry> pairs, String dest) throws IOException {
        dest = TextRulerToolkit.addTrailingSlashToPath(dest);
        String withTags = dest + "withtags";
        String withoutTags = dest + "withouttags";
        new File(withTags).mkdir();
        new File(withoutTags).mkdir();
        for (PairEntry pe : pairs) {
            File srcFile = new File(trainingDir + pe.trainingsFileName);
            File dstFile = new File(withTags);
            FileUtils.copyFile((File)srcFile, (File)dstFile);
            srcFile = new File(testDir + pe.testFileName);
            dstFile = new File(withoutTags);
            FileUtils.copyFile((File)srcFile, (File)dstFile);
        }
    }

    public static void makeXFoldCrossValidationSets(int partitionCount, List<PairEntry> pairs, String destinationPath) throws IOException {
        ArrayList<PairEntry> pairsCopy = new ArrayList<PairEntry>(pairs);
        int partSize = (int)Math.ceil((double)pairsCopy.size() / (double)partitionCount);
        Random rand = new Random();
        ArrayList partition = new ArrayList();
        for (int partNo = 0; partNo < partitionCount; ++partNo) {
            ArrayList<PairEntry> part = new ArrayList<PairEntry>();
            partition.add(part);
            if (partNo == partitionCount - 1) {
                part.addAll(pairsCopy);
                continue;
            }
            for (int i = 0; i < partSize; ++i) {
                int index = rand.nextInt(pairsCopy.size());
                part.add((PairEntry)pairsCopy.get(index));
                pairsCopy.remove(index);
            }
        }
        destinationPath = TextRulerToolkit.addTrailingSlashToPath(destinationPath);
        for (int i = 0; i < partitionCount; ++i) {
            String foldDest = destinationPath + i + "/";
            TextRulerToolkit.log("MK: " + new File(foldDest).mkdir());
            new File(foldDest + "training").mkdir();
            new File(foldDest + "testing").mkdir();
            new File(foldDest + "training/withtags").mkdir();
            new File(foldDest + "training/withouttags").mkdir();
            new File(foldDest + "testing/withtags").mkdir();
            new File(foldDest + "testing/withouttags").mkdir();
            String trainingWithTagsDir = foldDest + "training/withtags/";
            String trainingWithoutTagsDir = foldDest + "training/withouttags/";
            String testingWithTagsDir = foldDest + "testing/withtags/";
            String testingWithoutTagsDir = foldDest + "testing/withouttags/";
            for (PairEntry pe : (ArrayList)partition.get(i)) {
                File srcFile = new File(trainingDir + pe.trainingsFileName);
                File dstFile = new File(testingWithTagsDir);
                FileUtils.copyFile((File)srcFile, (File)dstFile);
                srcFile = new File(testDir + pe.testFileName);
                dstFile = new File(testingWithoutTagsDir);
                FileUtils.copyFile((File)srcFile, (File)dstFile);
            }
            for (int restI = 0; restI < partitionCount; ++restI) {
                if (restI == i) continue;
                for (PairEntry pe : (ArrayList)partition.get(restI)) {
                    File srcFile = new File(trainingDir + pe.trainingsFileName);
                    File dstFile = new File(trainingWithTagsDir);
                    FileUtils.copyFile((File)srcFile, (File)dstFile);
                    srcFile = new File(testDir + pe.testFileName);
                    dstFile = new File(trainingWithoutTagsDir);
                    FileUtils.copyFile((File)srcFile, (File)dstFile);
                }
            }
        }
    }

    public static class PairEntry {
        public String trainingsFileName;
        public String testFileName;
    }
}

