/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.parser.ast;

import java.util.List;
import org.apache.uima.ruta.ide.parser.ast.RutaAction;
import org.apache.uima.ruta.ide.parser.ast.RutaCondition;
import org.apache.uima.ruta.ide.parser.ast.RutaRule;
import org.apache.uima.ruta.ide.parser.ast.RutaRuleElement;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;

public class ComposedRuleElement
extends RutaRuleElement {
    List<Expression> elements;
    private Boolean disjunctive;

    public ComposedRuleElement(int start, int end, List<Expression> elements, List<Expression> quantifierExpressions, List<RutaCondition> conditionExpressions, List<RutaAction> actionExpressions, Boolean disjunctive) {
        super(start, end, null, quantifierExpressions, conditionExpressions, actionExpressions);
        if (elements != null) {
            this.elements = elements;
        }
        this.disjunctive = disjunctive;
    }

    @Override
    public int getKind() {
        return 1067;
    }

    @Override
    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Expression)this)) {
            if (this.elements != null) {
                for (Expression e : this.elements) {
                    e.traverse(visitor);
                }
            }
            if (this.quantifierExpressions != null) {
                for (Expression qpe : this.quantifierExpressions) {
                    qpe.traverse(visitor);
                }
            }
            if (this.conditions != null) {
                for (RutaCondition cond : this.conditions) {
                    cond.traverse(visitor);
                }
            }
            if (this.actions != null) {
                for (RutaAction action : this.actions) {
                    action.traverse(visitor);
                }
            }
            if (this.inlinedRules != null) {
                for (RutaRule rule : this.inlinedRules) {
                    rule.traverse(visitor);
                }
            }
        }
    }

    @Override
    public Expression getHead() {
        return this.head;
    }

    public List<Expression> getElements() {
        return this.elements;
    }

    public Boolean isDisjunctive() {
        return this.disjunctive;
    }

    public void setDisjunctive(Boolean disjunctive) {
        this.disjunctive = disjunctive;
    }
}

