/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.core.builder;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.uima.ruta.descriptor.RutaBuildOptions;
import org.apache.uima.ruta.descriptor.RutaDescriptorBuilder;
import org.apache.uima.ruta.descriptor.RutaDescriptorInformation;
import org.apache.uima.ruta.extensions.IEngineLoader;
import org.apache.uima.ruta.extensions.IRutaActionExtension;
import org.apache.uima.ruta.extensions.IRutaBlockExtension;
import org.apache.uima.ruta.extensions.IRutaBooleanFunctionExtension;
import org.apache.uima.ruta.extensions.IRutaConditionExtension;
import org.apache.uima.ruta.extensions.IRutaNumberFunctionExtension;
import org.apache.uima.ruta.extensions.IRutaStringFunctionExtension;
import org.apache.uima.ruta.extensions.IRutaTypeFunctionExtension;
import org.apache.uima.ruta.ide.RutaIdeCorePlugin;
import org.apache.uima.ruta.ide.core.RutaExtensionManager;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.apache.uima.ruta.ide.parser.ast.RutaModuleDeclaration;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.builder.AbstractBuildParticipantType;
import org.eclipse.dltk.core.builder.IBuildChange;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension2;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension3;
import org.eclipse.dltk.core.builder.IBuildState;
import org.eclipse.jface.preference.IPreferenceStore;

public class RutaBuilder
extends AbstractBuildParticipantType
implements IBuildParticipant,
IBuildParticipantExtension,
IBuildParticipantExtension2,
IBuildParticipantExtension3 {
    private IScriptProject project;

    public RutaBuilder() {
    }

    public RutaBuilder(IScriptProject project) {
        this.project = project;
    }

    private void generateDescriptorResources(ISourceModule sourceModule, ModuleDeclaration moduleDeclaration) {
        IProgressMonitor monitor;
        block6: {
            monitor = this.createMonitor(10);
            try {
                IContainer container = RutaBuilder.getContainer(sourceModule);
                IPath outputPath = RutaBuilder.getAbsolutePath(sourceModule);
                IPath[] generateResources = this.generateResources(moduleDeclaration, outputPath, container, sourceModule);
                IProject proj = sourceModule.getScriptProject().getProject();
                List<IFolder> allDescriptorFolders = RutaProjectUtils.getAllDescriptorFolders(proj);
                for (IFolder iFolder : allDescriptorFolders) {
                    RutaProjectUtils.addProjectDataPath(proj, iFolder);
                }
                monitor.worked(2);
                String defaultDescriptorLocation = RutaProjectUtils.getDefaultDescriptorLocation();
                IFolder folder = container.getProject().getFolder(defaultDescriptorLocation);
                for (IPath iPath : generateResources) {
                    IResource findMember = folder.findMember(iPath = iPath.makeRelativeTo(folder.getLocation()));
                    if (findMember == null) continue;
                    findMember.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                    findMember.getParent().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                }
                folder.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, generateResources.length));
                monitor.worked(1);
            }
            catch (ModelException e) {
                if (DLTKCore.DEBUG_PARSER) {
                    e.printStackTrace();
                }
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG_PARSER) break block6;
                e.printStackTrace();
            }
        }
        monitor.done();
    }

    private IPath[] generateResources(ModuleDeclaration moduleDeclaration, IPath outputPath, IContainer container, ISourceModule sourceModule) throws CoreException {
        ArrayList<IPath> result = new ArrayList<IPath>();
        if (moduleDeclaration instanceof RutaModuleDeclaration) {
            RutaModuleDeclaration tmmd = (RutaModuleDeclaration)moduleDeclaration;
            RutaDescriptorInformation sm = tmmd.descriptorInfo;
            IPath pathToModule = sourceModule.getResource().getLocation();
            String elementName = RutaProjectUtils.getModuleName(pathToModule);
            IScriptProject scriptProject = sourceModule.getScriptProject();
            IProject project = scriptProject.getProject();
            IPath descPath = RutaProjectUtils.getDescriptorRootPath(project);
            String basicTS = descPath.append("BasicTypeSystem.xml").toPortableString();
            String basicE = descPath.append("BasicEngine.xml").toPortableString();
            List<IFolder> descriptorFolders = RutaProjectUtils.getDescriptorFolders(project);
            for (IFolder iFolder : descriptorFolders) {
                File btsd = iFolder.getLocation().append("BasicTypeSystem.xml").toFile();
                File baed = iFolder.getLocation().append("BasicEngine.xml").toFile();
                if (!btsd.exists() || !baed.exists()) continue;
                basicTS = btsd.getAbsolutePath();
                basicE = baed.getAbsolutePath();
                descPath = iFolder.getLocation();
                break;
            }
            IPath relativePackagePath = RutaProjectUtils.getPackagePath(sourceModule.getResource().getLocation(), project);
            IPath descPackagePath = descPath.append(relativePackagePath);
            String typeSystem = descPackagePath.append(elementName + RutaProjectUtils.getTypeSystemSuffix(project) + ".xml").toPortableString();
            String engine = descPackagePath.append(elementName + RutaProjectUtils.getAnalysisEngineSuffix(project) + ".xml").toPortableString();
            String scriptWithPackagePath = RutaProjectUtils.getScriptWithPackage(pathToModule, project);
            ArrayList<String> scriptPathList = new ArrayList<String>();
            ArrayList<String> descriptorPathList = new ArrayList<String>();
            ArrayList<String> resourcePathList = new ArrayList<String>();
            try {
                List<IFolder> scriptFolders = RutaProjectUtils.getAllScriptFolders(scriptProject);
                scriptPathList.addAll(RutaProjectUtils.getFolderLocations(scriptFolders));
            }
            catch (CoreException e) {
                RutaIdeCorePlugin.error(e);
            }
            try {
                List<IFolder> allDescriptorFolders = RutaProjectUtils.getAllDescriptorFolders(project);
                descriptorPathList.addAll(RutaProjectUtils.getFolderLocations(allDescriptorFolders));
            }
            catch (Exception e) {
                RutaIdeCorePlugin.error(e);
            }
            try {
                List<IFolder> allResourceFolders = RutaProjectUtils.getAllResourceFolders(project);
                resourcePathList.addAll(RutaProjectUtils.getFolderLocations(allResourceFolders));
            }
            catch (Exception e) {
                RutaIdeCorePlugin.error(e);
            }
            String[] descriptorPaths = descriptorPathList.toArray(new String[0]);
            String[] scriptPaths = scriptPathList.toArray(new String[0]);
            String[] resourcePaths = resourcePathList.toArray(new String[0]);
            String mainScript = scriptWithPackagePath;
            mainScript = mainScript.replaceAll("/", ".");
            if (mainScript.endsWith(".ruta")) {
                mainScript = mainScript.substring(0, mainScript.length() - 5);
            }
            Collection<String> dependencies = RutaProjectUtils.getClassPath(project);
            URL[] urls = new URL[dependencies.size()];
            int counter = 0;
            for (String dep : dependencies) {
                try {
                    urls[counter] = new File(dep).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new CoreException((IStatus)new Status(4, "org.apache.uima.ruta.ide", e.getMessage()));
                }
                ++counter;
            }
            URLClassLoader classloader = new URLClassLoader(urls);
            this.build(basicTS, basicE, typeSystem, engine, sm, scriptPaths, descriptorPaths, resourcePaths, classloader);
            IPath tsPath = Path.fromPortableString((String)typeSystem);
            IPath ePath = Path.fromPortableString((String)engine);
            result.add(tsPath);
            result.add(ePath);
        }
        return result.toArray(new IPath[0]);
    }

    private void build(String basicTypesystem, String basicEngine, String typeSystemDest, String engineDest, RutaDescriptorInformation sm, String[] scriptPaths, String[] enginePaths, String[] resourcePaths, ClassLoader classloader) {
        block13: {
            RutaDescriptorBuilder builder;
            block12: {
                builder = null;
                try {
                    URL tsUrl = new File(basicTypesystem).toURI().toURL();
                    URL aeUrl = new File(basicEngine).toURI().toURL();
                    builder = new RutaDescriptorBuilder(tsUrl, aeUrl);
                }
                catch (Exception e) {
                    DLTKCore.error((String)e.getMessage(), (Throwable)e);
                    if (!DLTKCore.DEBUG_PARSER) break block12;
                    e.printStackTrace();
                }
            }
            IRutaConditionExtension[] conditionExtensions = RutaExtensionManager.getDefault().getRutaConditionExtensions();
            IRutaActionExtension[] actionExtensions = RutaExtensionManager.getDefault().getRutaActionExtensions();
            IRutaBooleanFunctionExtension[] booleanFunctionExtensions = RutaExtensionManager.getDefault().getRutaBooleanFunctionExtensions();
            IRutaNumberFunctionExtension[] numberFunctionExtensions = RutaExtensionManager.getDefault().getRutaNumberFunctionExtensions();
            IRutaStringFunctionExtension[] stringFunctionExtensions = RutaExtensionManager.getDefault().getRutaStringFunctionExtensions();
            IRutaTypeFunctionExtension[] typeFunctionExtensions = RutaExtensionManager.getDefault().getRutaTypeFunctionExtensions();
            IRutaBlockExtension[] blockExtensions = RutaExtensionManager.getDefault().getRutaBlockExtensions();
            IEngineLoader[] engineExtensions = RutaExtensionManager.getDefault().getEngineExtensions();
            ArrayList<String> language = new ArrayList<String>();
            ArrayList<String> engines = new ArrayList<String>();
            for (IRutaConditionExtension iRutaConditionExtension : conditionExtensions) {
                language.add(iRutaConditionExtension.getClass().getName());
            }
            for (IRutaConditionExtension iRutaConditionExtension : actionExtensions) {
                language.add(iRutaConditionExtension.getClass().getName());
            }
            for (IRutaConditionExtension iRutaConditionExtension : booleanFunctionExtensions) {
                language.add(iRutaConditionExtension.getClass().getName());
            }
            for (IRutaConditionExtension iRutaConditionExtension : numberFunctionExtensions) {
                language.add(iRutaConditionExtension.getClass().getName());
            }
            for (IRutaConditionExtension iRutaConditionExtension : stringFunctionExtensions) {
                language.add(iRutaConditionExtension.getClass().getName());
            }
            for (IRutaConditionExtension iRutaConditionExtension : typeFunctionExtensions) {
                language.add(iRutaConditionExtension.getClass().getName());
            }
            for (IRutaConditionExtension iRutaConditionExtension : blockExtensions) {
                language.add(iRutaConditionExtension.getClass().getName());
            }
            for (IRutaConditionExtension iRutaConditionExtension : engineExtensions) {
                engines.add(iRutaConditionExtension.getClass().getName());
            }
            try {
                RutaBuildOptions option = new RutaBuildOptions();
                option.setLanguageExtensions(language);
                option.setEngineLoaders(engines);
                IPreferenceStore store = RutaIdeCorePlugin.getDefault().getPreferenceStore();
                option.setImportByName(store.getBoolean("BuilderImportByName"));
                option.setResolveImports(store.getBoolean("BuilderResolveImports"));
                option.setClassLoader(classloader);
                builder.build(sm, typeSystemDest, engineDest, option, scriptPaths, enginePaths, resourcePaths);
            }
            catch (Exception e) {
                DLTKCore.error((String)e.getMessage(), (Throwable)e);
                if (!DLTKCore.DEBUG_PARSER) break block13;
                e.printStackTrace();
            }
        }
    }

    private IProgressMonitor createMonitor(int totalWork) {
        NullProgressMonitor pm = new NullProgressMonitor();
        pm.beginTask("Creating descriptors ", totalWork);
        return pm;
    }

    public static IContainer getContainer(ISourceModule sourceModule) {
        try {
            IResource file = sourceModule.getCorrespondingResource();
            return file.getParent();
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG_PARSER) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static IPath getAbsolutePath(ISourceModule sourceModule) {
        try {
            IResource file = sourceModule.getCorrespondingResource();
            IPath absolutePath = file.getRawLocation().removeLastSegments(1);
            return absolutePath;
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG_PARSER) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static IPath getRelativePath(ISourceModule sourceModule, String resourceName) {
        IContainer parent = RutaBuilder.getContainer(sourceModule);
        IPath relativePath = parent.getFullPath();
        IPath relativeFilePath = relativePath.append(resourceName);
        return relativeFilePath;
    }

    public void clean() {
    }

    public void prepare(IBuildChange buildChange, IBuildState buildState) throws CoreException {
    }

    public void buildExternalModule(IBuildContext context) throws CoreException {
    }

    public boolean beginBuild(int buildType) {
        return buildType != 10;
    }

    public void endBuild(IProgressMonitor monitor) {
    }

    public void build(IBuildContext context) throws CoreException {
        ModuleDeclaration ast = (ModuleDeclaration)context.get(IBuildContext.ATTR_MODULE_DECLARATION);
        ISourceModule sourceModule = context.getSourceModule();
        this.generateDescriptorResources(sourceModule, ast);
    }

    public IBuildParticipant createBuildParticipant(IScriptProject project) throws CoreException {
        return new RutaBuilder(project);
    }
}

