/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.RangeVariableDeclaration;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.instruct.GeneralVariable;
import net.sf.saxon.instruct.GlobalParam;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.query.Declaration;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

public class GlobalVariableDefinition
implements VariableDeclaration,
Declaration {
    protected List references = new ArrayList(10);
    private SequenceType requiredType;
    private Expression value;
    private int nameCode;
    private boolean isParameter;
    private String variableName;
    private String systemId;
    private int lineNumber;
    private GlobalVariable compiledVar;

    public void setRequiredType(SequenceType sequenceType) {
        this.requiredType = sequenceType;
    }

    public SequenceType getRequiredType() {
        return this.requiredType;
    }

    public void setNameCode(int n) {
        this.nameCode = n;
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return -1;
    }

    public String getPublicId() {
        return null;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String string) {
        this.variableName = string;
    }

    public void setValueExpression(Expression expression) {
        this.value = expression;
    }

    public void setIsParameter(boolean bl) {
        this.isParameter = bl;
    }

    public void registerReference(BindingReference bindingReference) {
        this.references.add(bindingReference);
    }

    public Iterator iterateReferences() {
        return this.references.iterator();
    }

    public GlobalVariable compile(StaticQueryContext staticQueryContext, int n) throws XPathException {
        GlobalVariable globalVariable;
        if (this.isParameter) {
            globalVariable = new GlobalParam();
            globalVariable.setExecutable(staticQueryContext.getExecutable());
            globalVariable.setRequiredParam(this.value == null);
        } else {
            globalVariable = new GlobalVariable();
            globalVariable.setExecutable(staticQueryContext.getExecutable());
        }
        globalVariable.setHostLanguage(51);
        globalVariable.setSelectExpression(this.value);
        globalVariable.setNameCode(this.nameCode);
        globalVariable.setRequiredType(this.requiredType);
        globalVariable.setVariableName(this.variableName);
        globalVariable.setSlotNumber(n);
        int n2 = globalVariable.getExecutable().getLocationMap().allocateLocationId(this.systemId, this.lineNumber);
        globalVariable.setLocationId(n2);
        Iterator iterator = this.references.iterator();
        while (iterator.hasNext()) {
            BindingReference bindingReference = (BindingReference)iterator.next();
            bindingReference.setStaticType(this.requiredType, null, 0);
            bindingReference.fixup(globalVariable);
        }
        staticQueryContext.getExecutable().registerGlobalVariable(globalVariable);
        int n3 = RangeVariableDeclaration.getReferenceCount(this.references, globalVariable, staticQueryContext, true);
        if (n3 < 10) {
            n3 = 10;
        }
        globalVariable.setReferenceCount(n3);
        this.compiledVar = globalVariable;
        return globalVariable;
    }

    public static void typeCheck(StaticQueryContext staticQueryContext, GeneralVariable generalVariable) throws XPathException {
        Serializable serializable;
        Serializable serializable2;
        Expression expression = generalVariable.getSelectExpression();
        if (expression != null) {
            Expression.setParentExpression(expression, generalVariable);
            serializable2 = new RoleLocator(3, staticQueryContext.getNamePool().getDisplayName(generalVariable.getNameCode()), 0, null);
            serializable = TypeChecker.strictTypeCheck(expression.simplify(staticQueryContext).typeCheck(staticQueryContext, Type.ITEM_TYPE), generalVariable.getRequiredType(), (RoleLocator)serializable2, staticQueryContext);
            serializable = ((Expression)serializable).optimize(staticQueryContext.getConfiguration().getOptimizer(), staticQueryContext, Type.ITEM_TYPE);
            generalVariable.setSelectExpression((Expression)serializable);
            Expression.setParentExpression((Expression)serializable, generalVariable);
            SlotManager slotManager = staticQueryContext.getConfiguration().makeSlotManager();
            int n = ExpressionTool.allocateSlots((Expression)serializable, 0, slotManager);
            if (n > 0) {
                ((GlobalVariable)generalVariable).setContainsLocals(slotManager);
            }
        }
        if (generalVariable.getRequiredType() == SequenceType.ANY_SEQUENCE && !(generalVariable instanceof GlobalParam)) {
            try {
                serializable2 = staticQueryContext.getConfiguration().getTypeHierarchy();
                serializable = expression.getItemType((TypeHierarchy)serializable2);
                int n = expression.getCardinality();
                generalVariable.setRequiredType(SequenceType.makeSequenceType((ItemType)serializable, n));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public GlobalVariable getCompiledVariable() {
        return this.compiledVar;
    }

    public void explain(Configuration configuration, PrintStream printStream) {
        NamePool namePool = configuration.getNamePool();
        printStream.println("declare variable " + namePool.getDisplayName(this.nameCode) + " := ");
        if (this.value != null) {
            this.value.display(4, System.err, configuration);
        }
        printStream.println(";");
    }
}

