/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.impl;

import java.util.Map;
import org.apache.uima.ResourceFactory;
import org.apache.uima.analysis_engine.impl.UimacppAnalysisEngineImpl;
import org.apache.uima.collection.CasConsumer;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.collection.base_cpm.CasDataConsumer;
import org.apache.uima.internal.util.Class_TCCL;
import org.apache.uima.resource.Resource;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.uimacpp.UimacppAnalysisComponent;

public class CasConsumerFactory_impl
implements ResourceFactory {
    @Override
    public Resource produceResource(Class<? extends Resource> aResourceClass, ResourceSpecifier aSpecifier, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        if (aSpecifier instanceof CasConsumerDescription) {
            CasConsumerDescription desc = (CasConsumerDescription)aSpecifier;
            String frameworkImpl = desc.getFrameworkImplementation();
            if (frameworkImpl == null || frameworkImpl.length() == 0) {
                throw new ResourceInitializationException("missing_framework_implementation", new Object[]{aSpecifier.getSourceUrlString()});
            }
            if (frameworkImpl.startsWith("org.apache.uima.java")) {
                Resource resource;
                String className = desc.getImplementationName();
                if (className == null || className.length() == 0) {
                    throw new ResourceInitializationException("missing_implementation_class_name", new Object[]{aSpecifier.getSourceUrlString()});
                }
                Class implClass = null;
                try {
                    implClass = Class_TCCL.forName(className, aAdditionalParams);
                }
                catch (ClassNotFoundException e) {
                    throw new ResourceInitializationException("class_not_found", new Object[]{className, aSpecifier.getSourceUrlString()}, e);
                }
                if (!CasConsumer.class.isAssignableFrom(implClass) && !CasDataConsumer.class.isAssignableFrom(implClass)) {
                    throw new ResourceInitializationException("not_a_cas_consumer", new Object[]{className, aSpecifier.getSourceUrlString()});
                }
                if (!aResourceClass.isAssignableFrom(implClass)) {
                    throw new ResourceInitializationException("resource_does_not_implement_interface", new Object[]{className, aResourceClass.getName(), aSpecifier.getSourceUrlString()});
                }
                try {
                    resource = (Resource)implClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new ResourceInitializationException("could_not_instantiate", new Object[]{className, aSpecifier.getSourceUrlString()}, e);
                }
                catch (IllegalAccessException e) {
                    throw new ResourceInitializationException("could_not_instantiate", new Object[]{className, aSpecifier.getSourceUrlString()}, e);
                }
                if (resource.initialize(aSpecifier, aAdditionalParams)) {
                    return resource;
                }
                throw new ResourceInitializationException("error_initializing_from_descriptor", new Object[]{className, aSpecifier.getSourceUrlString()});
            }
            if (frameworkImpl.startsWith("org.apache.uima.cpp")) {
                UimacppAnalysisEngineImpl resource = new UimacppAnalysisEngineImpl();
                if (resource.initialize(aSpecifier, aAdditionalParams)) {
                    return resource;
                }
                throw new ResourceInitializationException("error_initializing_from_descriptor", new Object[]{UimacppAnalysisComponent.class.getName(), aSpecifier.getSourceUrlString()});
            }
            throw new ResourceInitializationException("unsupported_framework_implementation", new Object[]{desc.getFrameworkImplementation(), aSpecifier.getSourceUrlString()});
        }
        return null;
    }
}

