/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.uima.internal.util.MsgLocalizationClassLoader;

public class I18nUtil {
    public static String localizeMessage(String aResourceBundleName, String aMessageKey, Object[] aArguments) {
        return I18nUtil.localizeMessage(aResourceBundleName, Locale.getDefault(), aMessageKey, aArguments, null);
    }

    public static String localizeMessage(String aResourceBundleName, String aMessageKey, Object[] aArguments, ClassLoader aLoader) {
        return I18nUtil.localizeMessage(aResourceBundleName, Locale.getDefault(), aMessageKey, aArguments, aLoader);
    }

    public static String localizeMessage(String aResourceBundleName, Locale aLocale, String aMessageKey, Object[] aArguments) {
        return I18nUtil.localizeMessage(aResourceBundleName, aLocale, aMessageKey, aArguments, null);
    }

    public static String localizeMessage(String aResourceBundleName, Locale aLocale, String aMessageKey, Object[] aArguments, ClassLoader aLoader) {
        ResourceBundle bundle = I18nUtil.resolveResourceBundle(aResourceBundleName, aLocale, aLoader);
        return I18nUtil.localizeMessage(bundle, aLocale, aMessageKey, aArguments);
    }

    public static ResourceBundle resolveResourceBundle(String aResourceBundleName, Locale aLocale, ClassLoader aLoader) {
        if (aLoader == null) {
            aLoader = MsgLocalizationClassLoader.getMsgLocalizationClassLoader();
        }
        if (aResourceBundleName == null) {
            return null;
        }
        return ResourceBundle.getBundle(aResourceBundleName, aLocale, aLoader);
    }

    public static String localizeMessage(ResourceBundle aResourceBundle, Locale aLocale, String aMessageKey, Object[] aArguments) {
        try {
            String message;
            String string = message = null == aResourceBundle ? "Null ResourceBundle, key = \"" + aMessageKey + "\"" : aResourceBundle.getString(aMessageKey);
            if (aResourceBundle != null && aArguments != null && aArguments.length > 0) {
                MessageFormat fmt = new MessageFormat(message);
                fmt.setLocale(aLocale);
                return fmt.format(aArguments);
            }
            return message;
        }
        catch (Exception e) {
            return "MESSAGE LOCALIZATION FAILED: " + e.getMessage();
        }
    }

    public static void setTccl(ClassLoader tccl) {
        MsgLocalizationClassLoader.CallClimbingClassLoader.originalTccl.set(tccl);
    }

    public static void removeTccl() {
        MsgLocalizationClassLoader.CallClimbingClassLoader.originalTccl.remove();
    }
}

