/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.impl;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.impl.ConfigurationManagerImplBase;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.util.Level;
import org.apache.uima.util.Settings;

public class ConfigurationManager_impl
extends ConfigurationManagerImplBase {
    protected static final String LOG_RESOURCE_BUNDLE = "org.apache.uima.impl.log_messages";
    private Map<String, Object> mSharedParamMap = Collections.synchronizedMap(new HashMap());

    @Override
    protected void declareParameters(String aGroupName, ConfigurationParameter[] aParams, ConfigurationParameterSettings aSettings, String aContextName, Settings aExternalOverrides) throws ResourceConfigurationException {
        super.declareParameters(aGroupName, aParams, aSettings, aContextName, aExternalOverrides);
        if (aParams != null) {
            for (int i = 0; i < aParams.length; ++i) {
                String qname = this.makeQualifiedName(aContextName, aParams[i].getName(), aGroupName);
                Object from = "";
                Object paramValue = aSettings.getParameterValue(aGroupName, aParams[i].getName());
                String extName = aParams[i].getExternalOverrideName();
                if (extName != null && aExternalOverrides != null) {
                    if (aParams[i].isMultiValued()) {
                        String[] propValues = aExternalOverrides.getSettingArray(extName);
                        if (propValues != null) {
                            paramValue = this.createParams(propValues, aParams[i].getType());
                            this.mLinkMap.remove(qname);
                            from = "(overridden from " + extName + ")";
                        }
                    } else {
                        String propValue = aExternalOverrides.getSetting(extName);
                        if (propValue != null) {
                            paramValue = this.createParam(propValue, aParams[i].getType());
                            this.mLinkMap.remove(qname);
                            from = "(overridden from " + extName + ")";
                        }
                    }
                }
                this.mSharedParamMap.put(qname, paramValue);
                if (!UIMAFramework.getLogger(this.getClass()).isLoggable(Level.CONFIG)) continue;
                Object realValue = paramValue;
                if (((String)from).length() == 0) {
                    String linkedTo = qname;
                    while (this.getLink(linkedTo) != null) {
                        linkedTo = this.getLink(linkedTo);
                    }
                    if (!linkedTo.equals(qname) && this.lookup(linkedTo) != null) {
                        realValue = this.lookup(linkedTo);
                        from = "(overridden from " + linkedTo + ")";
                    }
                }
                if (realValue == null) continue;
                if (aParams[i].isMultiValued()) {
                    try {
                        Object[] array = (Object[])realValue;
                        realValue = Arrays.toString(array);
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
                UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "declareParameters", LOG_RESOURCE_BUNDLE, "UIMA_parameter_set__CONFIG", new Object[]{aParams[i].getName(), aContextName, realValue, from});
            }
        }
    }

    @Override
    protected Object lookupSharedParamNoLinks(String aCompleteName) {
        return this.mSharedParamMap.get(aCompleteName);
    }

    private Object createParam(String value, String paramType) throws ResourceConfigurationException {
        if (paramType == null) {
            throw new IllegalArgumentException("Parameter type cannot be null");
        }
        switch (paramType) {
            case "String": {
                return value;
            }
            case "Boolean": {
                return this.createParamForClass(value, Boolean.class);
            }
            case "Integer": {
                return this.createParamForClass(value, Integer.class);
            }
            case "Long": {
                return this.createParamForClass(value, Long.class);
            }
            case "Float": {
                return this.createParamForClass(value, Float.class);
            }
            case "Double": {
                return this.createParamForClass(value, Double.class);
            }
        }
        throw new IllegalArgumentException("Unsupported parameter type [" + paramType + "]");
    }

    private Object createParams(String[] values, String paramType) {
        if (paramType == null) {
            throw new IllegalArgumentException("Parameter type cannot be null");
        }
        switch (paramType) {
            case "String": {
                return values;
            }
            case "Boolean": {
                return this.createParamsForClass(values, Boolean.class);
            }
            case "Integer": {
                return this.createParamsForClass(values, Integer.class);
            }
            case "Long": {
                return this.createParamsForClass(values, Long.class);
            }
            case "Float": {
                return this.createParamsForClass(values, Float.class);
            }
            case "Double": {
                return this.createParamsForClass(values, Double.class);
            }
        }
        throw new IllegalArgumentException("Unsupported parameter type [" + paramType + "]");
    }

    private <T> Object createParamForClass(String value, Class<T> clas) throws ResourceConfigurationException {
        try {
            Method valOf = clas.getMethod("valueOf", String.class);
            return valOf.invoke(null, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            if (e.getCause() instanceof NumberFormatException) {
                throw new ResourceConfigurationException("external_override_numeric_error", new Object[]{value});
            }
            throw new ResourceConfigurationException(e);
        }
    }

    private <T> Object createParamsForClass(String[] values, Class<T> clas) {
        try {
            Method valOf = clas.getMethod("valueOf", String.class);
            Object[] result = (Object[])Array.newInstance(clas, values.length);
            for (int i = 0; i < values.length; ++i) {
                result[i] = valOf.invoke(null, values[i]);
            }
            return result;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException(e.getCause());
        }
    }
}

